<?php
/**
 * Theme Customizer
 *
 * @package Businesity
 */

function businesity_customize_register( $wp_customize ) {

	require get_theme_file_path() . '/inc/customizer/header-options.php';

	require get_theme_file_path() . '/inc/customizer/goal.php';

	require get_theme_file_path() . '/inc/customizer/features.php';

	require get_theme_file_path() . '/inc/customizer/case-study.php';

}
add_action( 'customize_register', 'businesity_customize_register' );


function businesity_customize_control_style() {

	wp_enqueue_style( 'businesity-customize-controls-css', get_theme_file_uri() . '/inc/customizer/css/customizer-style.css' );

}
add_action( 'customize_controls_enqueue_scripts', 'businesity_customize_control_style' );


/*============= Active Callbacks =============*/

// Goal section.
function businesity_is_goal_section_enabled( $control ) {
	return ( $control->manager->get_setting( 'businesity_enable_goal_section' )->value() );
}
function businesity_is_goal_section_and_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'businesity_goal_content_type' )->value();
	return ( businesity_is_goal_section_enabled( $control ) && ( 'post' === $content_type ) );
}
function businesity_is_goal_section_and_content_type_page_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'businesity_goal_content_type' )->value();
	return ( businesity_is_goal_section_enabled( $control ) && ( 'page' === $content_type ) );
}
function businesity_is_goal_section_and_additional_box_enabled( $control ) {
	$additional_box = $control->manager->get_setting( 'businesity_enable_goal_box' )->value();
	return ( businesity_is_goal_section_enabled( $control ) && ( true === $additional_box ) );
}

// Features section.
function businesity_is_features_section_enabled( $control ) {
	return ( $control->manager->get_setting( 'businesity_enable_features_section' )->value() );
}
function businesity_is_features_section_and_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'businesity_features_content_type' )->value();
	return ( businesity_is_features_section_enabled( $control ) && ( 'post' === $content_type ) );
}
function businesity_is_features_section_and_content_type_page_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'businesity_features_content_type' )->value();
	return ( businesity_is_features_section_enabled( $control ) && ( 'page' === $content_type ) );
}
function businesity_is_features_section_and_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'businesity_features_content_type' )->value();
	return ( businesity_is_features_section_enabled( $control ) && ( 'category' === $content_type ) );
}

// Case Study section.
function businesity_is_case_study_section_enabled( $control ) {
	return ( $control->manager->get_setting( 'businesity_enable_case_study_section' )->value() );
}
function businesity_is_case_study_section_and_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'businesity_case_study_content_type' )->value();
	return ( businesity_is_case_study_section_enabled( $control ) && ( 'post' === $content_type ) );
}
function businesity_is_case_study_section_and_content_type_page_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'businesity_case_study_content_type' )->value();
	return ( businesity_is_case_study_section_enabled( $control ) && ( 'page' === $content_type ) );
}
function businesity_is_case_study_section_and_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'businesity_case_study_content_type' )->value();
	return ( businesity_is_case_study_section_enabled( $control ) && ( 'category' === $content_type ) );
}
