<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Businesity
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no" >
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'businesity' ); ?></a>
	<header id="masthead" class="site-header">
		<div class="top-nav">
			<div class="container">
				<div class="row align-items-center">
					<div class="col-lg-3 col-6">
						<div class="site-branding">
							<div class="site-logo">
								<?php the_custom_logo(); ?>
							</div>
							<div class="site-identity">
								<?php
								if ( is_front_page() && is_home() ) :
									?>
									<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
									<?php
								else :
									?>
									<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
									<?php
								endif;
								$businesity_description = get_bloginfo( 'description', 'display' );
								if ( $businesity_description || is_customize_preview() ) :
									?>
									<p class="site-description"><?php echo esc_html( $businesity_description ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></p>
									<?php
								endif;
								?>
							</div>
						</div><!-- .site-branding -->
					</div>
					<div class="col-lg-9 col-6 d-flex contact-buttons">
						<div class="top-header-contact">
							<?php
							$contact_label  = get_theme_mod( 'businesity_contact_label' );
							$contact_number = get_theme_mod( 'businesity_contact_number' );
							$email_label    = get_theme_mod( 'businesity_email_label' );
							$email_address  = get_theme_mod( 'businesity_email_address' );
							if ( ! empty( $contact_label ) || ! empty( $contact_number ) ) {
								?>
								<div class="header-contact-inner">
									<span class="contact-details">
										<i class="fas fa-phone-volume"></i>
										<span><a href="tel:<?php echo esc_attr( $contact_number ); ?>"><?php echo esc_html( $contact_number ); ?></a></span>
									</span>
									<span class="contact-head">
										<span><?php echo esc_html( $contact_label ); ?></span>
									</span>
								</div>
								<?php
							}
							if ( ! empty( $email_label ) || ! empty( $email_address ) ) {
								?>
								<div class="header-contact-inner">
									<span class="contact-details">
										<i class="fas fa-envelope"></i>
										<span><a href="mailto:<?php echo esc_attr( $email_address ); ?>"><?php echo esc_html( $email_address ); ?></a></span>
									</span>
									<span class="contact-head">
										<span><?php echo esc_html( $email_label ); ?></span>
									</span>
								</div>
								<?php
							}
							?>
						</div>
						<ul class="top-icons">
							<?php if ( class_exists( 'woocommerce' ) ) : ?>
								<li><a href="<?php echo get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ); ?>"><img src="<?php echo esc_url( get_stylesheet_directory_uri() ); ?>/assets/images/user.svg" alt=""></a></li>
								<li><a href="<?php echo wc_get_cart_url(); ?>"><img src="<?php echo esc_url( get_stylesheet_directory_uri() ); ?>/assets/images/cart.svg" alt=""></a></li>
							<?php endif; ?>
							<?php if ( get_theme_mod( 'charityup_enable_search_form', true ) ) { ?>
								<li class="menu-item-search">
									<a href="#" id="search-btn">
										<i class="fas fa-search"></i>
									</a>
									<div id="search-overlay" class="block">
										<div class="centered">
											<div id='search-box'>
												<a href="#" id="close-btn" class="fa fa-times fa-2x"></a>
												<?php get_search_form(); ?>
											</div>
										</div>
									</div>
								</li>
							<?php } ?>
						</ul>
					</div>
				</div>
			</div>
		</div>
		<div class="bottom-nav">
			<div class="container">
				<div class="row bottom-nav-wrap">
					<div class="col-lg-9 col-6">
						<nav id="site-navigation" class="main-navigation">
							<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false">
								<div class="ham-wrap">
									<div class="ham-icon">
										<span></span>
										<span></span>
										<span></span>
									</div>
								</div>
							</button>
							<div class="main-menu">
								<?php
								if ( has_nav_menu( 'primary' ) ) {
									wp_nav_menu(
										array(
											'theme_location' => 'primary',
											'menu_id' => 'primary-menu',
										)
									);
								}
								?>
							</div>
						</nav><!-- #site-navigation --> 
					</div>

					<?php
					if ( get_theme_mod( 'charityup_enable_custom_button', true ) ) {
						$custom_button_label = get_theme_mod( 'charityup_custom_button_label', 'Donate' );
						$custom_button_link  = get_theme_mod( 'charityup_custom_button_link' );
						$custom_button_link  = ! empty( $custom_button_link ) ? $custom_button_link : '#';
						?>
						<div class="col-lg-3 col-6">
							<div class="charity-custom-btn">
								<a class="btn primary-btn" href="<?php echo esc_url( $custom_button_link ); ?>"><?php echo esc_html( $custom_button_label ); ?></a>
							</div>
						</div>
					<?php } ?>
				</div>
			</div>
		</div>		
	</header><!-- #masthead -->
