<?php
/**
 * Businesity functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Businesity
 */

if ( ! function_exists( 'businesity_setup' ) ) :
	function businesity_setup() {
		/*
		* Make child theme available for translation.
		* Translations can be filed in the /languages/ directory.
		*/
		load_child_theme_textdomain( 'businesity', get_stylesheet_directory() . '/languages' );

		// Remove menu items added from parent theme.
		remove_filter( 'wp_nav_menu_items', 'charityup_add_menu_item', 10, 2 );
	}
endif;
add_action( 'after_setup_theme', 'businesity_setup' );

if ( ! function_exists( 'businesity_enqueue_styles' ) ) :
	function businesity_enqueue_styles() {
		// Append .min if SCRIPT_DEBUG is false.
		$min = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

		$parenthandle = 'charityup-style';
		$theme        = wp_get_theme();
		wp_enqueue_style(
			$parenthandle,
			get_template_directory_uri() . '/style.css',
			array(
				'charityup-bootstrap',
				'charityup-fontawesome',
				'charityup-fontawesome-solid',
				'charityup-fontawesome-brand',
				'charityup-slick',
				'charityup-slick-theme',
				'charityup-google-fonts',
			),
			$theme->parent()->get( 'Version' )
		);
		wp_enqueue_style(
			'businesity-style',
			get_stylesheet_uri(),
			array( $parenthandle ),
			$theme->get( 'Version' )
		);

		wp_enqueue_script( 'businesity-script', get_stylesheet_directory_uri() . '/assets/js/custom' . $min . '.js', array( 'jquery', 'charityup-main-script' ), $theme->get( 'Version' ), true );
	}
endif;
add_action( 'wp_enqueue_scripts', 'businesity_enqueue_styles' );

require get_theme_file_path() . '/inc/customizer.php';

/**
 * Default Colors
 */
function charityup_get_default_color() {
	$color['primary']   = '#548cff';
	$color['secondary'] = '#4551f9';
	return $color;
}

if ( ! function_exists( 'businesity_dynamic_css' ) ) :
	/**
	 * Dynamic CSS
	 */
	function businesity_dynamic_css() {
		$default_color = charityup_get_default_color();

		$primary_color   = get_theme_mod( 'primary_color', $default_color['primary'] );
		$secondary_color = get_theme_mod( 'secondary_color', $default_color['secondary'] );

		$custom_css = '
		.case-study-single .case-study-content a:hover,
		.case-study-single .case-study-content a:focus {
			color: ' . esc_attr( $primary_color ) . ';
		}

		.site-header {
			background-color: ' . esc_attr( $primary_color ) . ';
		}

		.charity-custom-btn .btn:hover,
		.charity-custom-btn .btn:focus {
			background-color: ' . esc_attr( $secondary_color ) . ';
		}
		';

		wp_add_inline_style( 'businesity-style', $custom_css );
	}
endif;
add_action( 'wp_enqueue_scripts', 'businesity_dynamic_css', 99 );
