<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Businesity
 */

get_header();

if ( is_front_page() && is_home() ) {
	require get_template_directory() . '/home.php';
} elseif ( is_front_page() && ! is_home() ) {
	?>
	<main id="primary" class="site-main">
		<?php
		require get_template_directory() . '/sections/sections.php';

		$homepage_sections = array( 'banner', 'features', 'goal', 'case-study', 'counter', 'event', 'team', 'blog' );
		foreach ( $homepage_sections as $value ) {
			if ( in_array( $value, array( 'features', 'goal', 'case-study' ) ) ) {
				require get_theme_file_path() . '/inc/sections/' . $value . '.php';
			} else {
				require get_template_directory() . '/sections/' . $value . '.php';
			}
		}
		?>
	</main><!-- #main -->
	<?php
}

if ( true === get_theme_mod( 'charityup_enable_frontpage_content', false ) ) {
	?>
	<div id="content" class="site-content">
		<div class="container">
			<div class="wrapper">
				<div class="left-side">
					<?php
					while ( have_posts() ) :
						the_post();

						get_template_part( 'template-parts/content', 'page' );

						// If comments are open or we have at least one comment, load up the comment template.
						if ( comments_open() || get_comments_number() ) :
							comments_template();
						endif;

					endwhile; // End of the loop.
					?>
				</div>
				<?php if ( charityup_is_sidebar_enabled() ) : ?>
					<div class="right-side">
						<?php get_sidebar(); ?>
					</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
	<?php
}

get_footer();
