<?php
/**
 * Load files.
 *
 * @package Blog_Era_Plus
 */
/**
*  Get theme options
*/
if ( ! function_exists( 'blog_era_plus_get_option' ) ) :

	/**
	 * Get theme option
	 *
	 * @since 1.0.0
	 *
	 * @param string $key Option key.
	 * @return mixed Option value.
	 */
function blog_era_plus_get_option( $key ) {

	$default_options = blog_era_plus_get_default_theme_options();

	if ( empty( $key ) ) {
		return;
	}

	$theme_options = (array)get_theme_mod( 'theme_options' );
	$theme_options = wp_parse_args( $theme_options, $default_options );

	$value = null;

	if ( isset( $theme_options[ $key ] ) ) {
		$value = $theme_options[ $key ];
	}

	return $value;
}

endif;



if ( ! function_exists( 'blog_era_plus_get_default_theme_options' ) ) :

	/**
	 * Get default theme options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Default theme options.
	 */
function blog_era_plus_get_default_theme_options() {

	$defaults = array();

	
	/******************************** Layout Setting ********************************/	
	$defaults['layout_options'] 					= 'right'; 
	$defaults['primary_color'] 						= '#079cd4';

	// Pass through filter.
	//$defaults = apply_filters( 'blog_era_plus_filter_default_theme_options', $defaults );

	return $defaults;
}

endif;


//  Customizer Control
if (class_exists('WP_Customize_Control') && ! class_exists( 'Blog_Era_Plus_Image_Radio_Control' ) ) {
    /**
    * Customize sidebar layout control.
    */
    class Blog_Era_Plus_Image_Radio_Control extends WP_Customize_Control {

        public function render_content() {

            if (empty($this->choices))
                return;

            $name = '_customize-radio-' . $this->id;
            ?>
            <span class="customize-control-title"><?php echo esc_html($this->label); ?></span>
            <ul class="controls" id='blog-era-img-container'>
                <?php
                foreach ($this->choices as $value => $label) :
                    $class = ($this->value() == $value) ? 'blog-era-radio-img-selected blog-era-radio-img-img' : 'blog-era-radio-img-img';
                    ?>
                    <li style="display: inline;">
                        <label>
                            <input <?php $this->link(); ?>style = 'display:none' type="radio" value="<?php echo esc_attr($value); ?>" name="<?php echo esc_attr($name); ?>" <?php
                                                          $this->link();
                                                          checked($this->value(), $value);
                                                          ?> />
                            <img src='<?php echo esc_url($label); ?>' class='<?php echo esc_attr($class); ?>' />
                        </label>
                    </li>
                    <?php
                endforeach;
                ?>
            </ul>
            <?php
        }

    }
}


function blog_era_plus_dynamic_styles(){

	$primary_color  		=  esc_attr( blog_era_plus_get_option( 'primary_color' ) );
	
	$custom_css = "
		.banner-side.no-image,
		.owl-carousel .owl-nav .owl-prev,
		.owl-carousel .owl-nav .owl-next,
		.owl-theme .owl-nav [class*=owl-]:hover,
		td#today,
		.widget_search .search-submit,
		a.btn:before,
		.back-to-top,
		.main-menu,
		.top-menu,
        .main-navigation ul ul{
			background: {$primary_color};
		}";
	$custom_css .= "
	    .widget ul li a:hover:before,
        .site-footer .widget ul li a:hover:before,
        .navigation .nav-previous:hover:before,
        .navigation .nav-next:hover:after,
        .navigation .nav-previous a:hover,
        .navigation .nav-next a:hover,
        a.btn:hover,
        a.btn:hover:after,
        .blog-content-detail:hover .blog-content-caption .entry-title a,            
        a:hover,
        a:focus,
        a:active,
        .top-address-part li:hover i,
        .top-address-part li a:hover,
        .top-menu-holder li a:hover,
        .top-address-part li a:hover i,
        .top-menu-holder ul li a:hover i,
        .cat-links:hover i,
        .tags-links:hover i,
        .entry-meta span:hover i,
        .widget ul li a:hover, 
        .blog-content-detail .blog-content-caption .entry-title a:hover,
        .owl-carousel .owl-nav .owl-next:before,
        .owl-carousel .owl-nav .owl-prev:before,
        .blog-slider-caption .entry-title:hover,
        .banner-side-content .entry-title:hover,
        .about-caption .entry-title:hover,
        .banner-side.no-image,
        a.btn:before{
			color: {$primary_color};
		}";

	$custom_css .= "
        .owl-carousel .owl-nav .owl-next,
        .owl-carousel .owl-nav .owl-prev,
        .widget_calendar .calendar_wrap,
        .widget_calendar tbody,
        .widget_calendar thead,
        .widget_calendar caption,
        .blog-content-detail{
			border-color: {$primary_color};
		}";		

	$custom_css .= "
        .widget-title span:before{
			border-bottom: 2px solid $primary_color;
		}";			

	wp_add_inline_style( 'blog-era-plus-style', $custom_css );
}

add_action( 'wp_enqueue_scripts', 'blog_era_plus_dynamic_styles' );


