<?php 
/**
 * Blog Era Plus Theme Customizer
 *
 * @package Blog_Era_Plus
 */

function blog_era_plus_customize_register( $wp_customize ) {


	$default = blog_era_plus_get_default_theme_options();	

	/*****************Layout Setting Section  *****************/
	$wp_customize->add_section('section_layout', array(    
		'title'       => esc_html__('Layout Option', 'blog-era-plus'),
		'panel'       => 'theme_option_panel'    
		));	

	/************************* Layout Options ******************************************/
	$wp_customize->add_setting('theme_options[layout_options]', 
		array(
			'default' 			=> $default['layout_options'],
			'type'              => 'theme_mod',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'blog_era_sanitize_select'
			)
		);

	$wp_customize->add_control(new Blog_Era_Plus_Image_Radio_Control($wp_customize, 'theme_options[layout_options]', 
		array(		
			'label' 	=> esc_html__('Sidebar Layout Options', 'blog-era-plus'),
			'section' 	=> 'section_layout',
			'settings'  => 'theme_options[layout_options]',
			'type' 		=> 'radio-image',
			'choices' 	=> array(		
				'left' 			=> get_stylesheet_directory_uri() . '/assets/img/left-sidebar.png',							
				'right' 		=> get_stylesheet_directory_uri() . '/assets/img/right-sidebar.png',
				'no-sidebar' 	=> get_stylesheet_directory_uri() . '/assets/img/no-sidebar.png',
				'both-sidebar' 	=> get_stylesheet_directory_uri() . '/assets/img/both-sidebar.png',
				),	
			))
	);

	/******************************* Primary Color ***************************************************/
	$wp_customize->add_setting('theme_options[primary_color]', 
	    array(
	    'default'           => $default['primary_color'],        
	    'sanitize_callback' => 'sanitize_hex_color'
	    )
	);

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize,'theme_options[primary_color]',
	        array(
	        'label'       => esc_html__( 'Primary Color', 'blog-era-plus' ),        
	        'settings'    => 'theme_options[primary_color]',
	        'section'     => 'colors',                                  
	        )
	    )
	);	

}
add_action( 'customize_register', 'blog_era_plus_customize_register', 15 );