<?php
/**
 * Blog Era Plus functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Blog_Era_Plus
 */

/**
 * Enqueue scripts and styles.
 */
function blog_era_plus_scripts() {

	// Animate Css
	wp_enqueue_style( 'animate', get_stylesheet_directory_uri().'/assets/css/animate.min.css', array(), '1.0.0' );

	wp_enqueue_style( 'blog-era-plus-style', get_template_directory_uri() . '/style.css' );
	
	//viewportchecker
	wp_enqueue_script( 'jquery-viewportchecker', get_stylesheet_directory_uri().'/assets/js/jquery.viewportchecker.js', array('jquery'), false, true );

	wp_enqueue_script( 'blog-era-plus-custom', get_stylesheet_directory_uri() . '/assets/js/custom-main.js', array( 'jquery' ), '20180228', true );


	
}

add_action( 'wp_enqueue_scripts', 'blog_era_plus_scripts' );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function blog_era_plus_widgets_init() {

	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar Left', 'blog-era-plus' ),
		'id'            => 'sidebar-left',
		'description'   => esc_html__( 'Add widgets here.', 'blog-era-plus' ),
		'before_widget' => '<div id="%1$s" class="single-sidebar widget %2$s ">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2 class="widget-title"><span>',
		'after_title'   => '</span></h2>',
	) );


}
add_action( 'widgets_init', 'blog_era_plus_widgets_init' );


// Load functions
require_once trailingslashit( get_stylesheet_directory() ) . '/inc/init-function.php';


// Load Customizer Options.
require_once trailingslashit( get_stylesheet_directory() ) . '/inc/customizer-inc.php';


