<?php
$theme             = wp_get_theme();
$i18n              = \Codemanas\ThemeInfo\Translations::get_instance();
$text              = $i18n->get_header_translations();
$dashed_theme_name = $dashed_theme_name ?? '';
?>
<div class="cm-admin-topbar">
    <div class="cm-admin-topbar__header">
        <img class="cm-admin-topbar__header-logo" src="<?php echo esc_url( get_template_directory_uri() . '/vendor/codemanas/theme-info/img/cm-block-logo.webp' ) ?>" alt="CM Blocks Logo"/>
        <h2><?php echo esc_html( $theme['Name'] ); ?></h2>
    </div>
</div>
<div class="cm-admin-top-right__section">
    <a href="<?php esc_url( 'https://cmblocks.com/pricing/' ); ?>" class="cm-admin-top-right__link cm-admin-top-right__link--highlight">Upgrade to Pro</a>
    <a href="<?php echo esc_url( 'https://demo.cmblocks.com/' . $dashed_theme_name . '/' ) ?>" class="cm-admin-top-right__link" target="_blank"><?php echo $text['demo_link'] ?></a>
    <a href="https://docs.cmblocks.com/" target="_blank" class="cm-admin-top-right__link"><?php echo $text['documentation'] ?></a>
</div>