<?php
$text              = \Codemanas\ThemeInfo\Translations::get_instance()->get_general_tab();
$dashed_theme_name = $dashed_theme_name ?? '';
$edit_svg          = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><!--!Font Awesome Free 6.7.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.--><path d="M441 58.9L453.1 71c9.4 9.4 9.4 24.6 0 33.9L424 134.1 377.9 88 407 58.9c9.4-9.4 24.6-9.4 33.9 0zM209.8 256.2L344 121.9 390.1 168 255.8 302.2c-2.9 2.9-6.5 5-10.4 6.1l-58.5 16.7 16.7-58.5c1.1-3.9 3.2-7.5 6.1-10.4zM373.1 25L175.8 222.2c-8.7 8.7-15 19.4-18.3 31.1l-28.6 100c-2.4 8.4-.1 17.4 6.1 23.6s15.2 8.5 23.6 6.1l100-28.6c11.8-3.4 22.5-9.7 31.1-18.3L487 138.9c28.1-28.1 28.1-73.7 0-101.8L474.9 25C446.8-3.1 401.2-3.1 373.1 25zM88 64C39.4 64 0 103.4 0 152L0 424c0 48.6 39.4 88 88 88l272 0c48.6 0 88-39.4 88-88l0-112c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 112c0 22.1-17.9 40-40 40L88 464c-22.1 0-40-17.9-40-40l0-272c0-22.1 17.9-40 40-40l112 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L88 64z"/></svg>';

$quick_settings = [
	'header'        => [
		'title'       => $text['quick_settings']['header']['title'],
		'description' => $text['quick_settings']['header']['desc'],
		'link'        => admin_url( '/site-editor.php?postId=' . $dashed_theme_name . '%2F%2Fheader&postType=wp_template_part&canvas=edit' ),
	],
	'footer'        => [
		'title'       => $text['quick_settings']['footer']['title'],
		'description' => $text['quick_settings']['footer']['desc'],
		'link'        => admin_url( '/site-editor.php?postType=wp_template_part&postId=' . $dashed_theme_name . '%2F%2Ffooter&canvas=edit' ),
	],
	'global_styles' => [
		'title'       => $text['quick_settings']['global_styles']['title'],
		'description' => $text['quick_settings']['global_styles']['desc'],
		'link'        => admin_url( '/site-editor.php?path=%2Fwp_global_styles&canvas=edit' ),
	],
	'navigation'    => [
		'title'       => $text['quick_settings']['navigation']['title'],
		'description' => $text['quick_settings']['navigation']['desc'],
		'link'        => admin_url( '/site-editor.php?path=%2Fnavigation' ),
	],
	'all_templates' => [
		'title'       => $text['quick_settings']['templates']['title'],
		'description' => $text['quick_settings']['templates']['desc'],
		'link'        => admin_url( 'site-editor.php?path=%2Fwp_template%2Fall' ),
	],
	'patterns'      => [
		'title'       => $text['quick_settings']['patterns']['title'],
		'description' => 'Patterns are predefined block layouts that help you quickly design and organize content on your WordPress site with ease.',
		'link'        => admin_url( 'site-editor.php?postType=wp_block' ),
	],
];
$plugins        = [
	'zoom'      => [
		'title'       => $text['plugins']['zoom']['title'],
		'image_url'   => get_theme_file_uri( '/vendor/codemanas/theme-info/img/zoom.png' ),
		'description' => $text['plugins']['zoom']['desc'],
		'slug'        => 'video-conferencing-with-zoom-api',
		'filename'    => 'video-conferencing-with-zoom-api',
	],
	'typesense' => [
		'title'       => $text['plugins']['typesense']['title'],
		'image_url'   => get_theme_file_uri( '/vendor/codemanas/theme-info/img/typesense.png' ),
		'description' => $text['plugins']['typesense']['desc'],
		'slug'        => 'search-with-typesense',
		'filename'    => 'codemanas-typesense',
	],
	'popup'     => [
		'title'       => $text['plugins']['simple_popup']['title'],
		'image_url'   => get_theme_file_uri( '/vendor/codemanas/theme-info/img/popup.png' ),
		'description' => $text['plugins']['simple_popup']['desc'],
		'slug'        => 'simple-popup-block',
		'filename'    => 'simple-popup-block',
	],
];

?>

<div class="tab-panel active" data-tab="tab1">
    <div class="tab-section__wrapper">
        <!-- Quick Settings Section -->
        <div class="tab-section">
            <h3 class="section-header"><?php echo $text['tab_title']; ?></h3>
			<?php if ( ! is_plugin_active( 'cm-blocks/cm-blocks.php' ) ) : ?>
                <br/>
                <p class="cm-admin-small-warning"><?php echo $text['sticky_header_info']; ?>
                    <a href="https://wordpress.org/plugins/cm-blocks/" target="_blank"><?php echo $text['cm_blocks']; ?></a>
                </p>
			<?php endif; ?>
            <div class="quick-setting__wrapper">
				<?php foreach ( $quick_settings as $key => $setting ) : ?>
                    <div class="quick-setting__card">
                        <div class="quick-setting__card-title">
                            <h4><?php echo $setting['title']; ?></h4>
                            <a href="<?php echo esc_url( $setting['link'] ); ?>">
								<?php echo $edit_svg; ?>
                            </a>
                        </div>
                        <p class="cm-admin-small-warning"><?php echo $setting['description']; ?></p>
                    </div>
				<?php endforeach; ?>
            </div>
        </div>
        <!-- Our Plugins Section -->
        <div class="plugins-tab-section">
            <h3 class="section-header"><?php echo $text['our_plugins']; ?></h3>
            <div class="plugins__wrapper">
				<?php foreach ( $plugins as $name => $plugin ) : ?>
                    <div class="plugins__card">
                        <div class="plugins__card-header">
                            <h4 class="plugin-title"><?php echo $plugin['title']; ?></h4>
                            <img class="plugins__card-img" src="<?php echo esc_url( $plugin['image_url'] ); ?>" alt="<?php echo esc_attr( $plugin['title'] ); ?>">
                        </div>
                        <p class="desc plugins__card-desc"><?php echo esc_attr( $plugin['description'] ); ?></p>
						<?php
						Codemanas\ThemeInfo\PluginInstaller::render_installer_button( $plugin['slug'], $plugin['filename'] );
						?>
                    </div>
				<?php endforeach; ?>
            </div>
        </div>
    </div>

    <!-- Sidebar -->
	<?php include_once get_template_directory() . '/vendor/codemanas/theme-info/src/templates/sidebar.php'; ?>
</div>