<?php
$translations     = $translations ?? [];
$progressBar_icon = get_template_directory_uri() . '/vendor/codemanas/theme-info/img/progressBar-icon.png';
$text             = \Codemanas\ThemeInfo\Translations::get_instance()->get_cm_blocks_tab();
$items            = [
	[
		'icon'          => get_template_directory_uri() . '/vendor/codemanas/theme-info/img/slider-icon.png',
		'alt'           => $text['blocks']['slider']['title'],
		'title'         => $text['blocks']['slider']['title'],
		'desc'          => $text['blocks']['slider']['desc'],
		'docs_url'      => 'https://docs.cmblocks.com/slider/',
		'live_demo_url' => 'https://cmblocks.com/cm-blocks/slider#slider-demo'
	],
	[
		'icon'          => get_template_directory_uri() . '/vendor/codemanas/theme-info/img/accordion-icon.png',
		'alt'           => $text['blocks']['accordion']['title'],
		'title'         => $text['blocks']['accordion']['title'],
		'desc'          => $text['blocks']['accordion']['desc'],
		'docs_url'      => 'https://docs.cmblocks.com/accordion/',
		'live_demo_url' => 'https://cmblocks.com/accordion/#accordion-demo'
	],
	[
		'icon'          => get_template_directory_uri() . '/vendor/codemanas/theme-info/img/masonry-icon.png',
		'alt'           => $text['blocks']['masonry-gallery']['title'],
		'title'         => $text['blocks']['masonry-gallery']['title'],
		'desc'          => $text['blocks']['masonry-gallery']['desc'],
		'docs_url'      => 'https://docs.cmblocks.com/masonry-gallery/',
		'live_demo_url' => 'https://cmblocks.com/masonry-gallery/#masonry-demo'
	],
	[
		'icon'          => get_template_directory_uri() . '/vendor/codemanas/theme-info/img/progressBar-icon.png',
		'alt'           => $text['blocks']['progress-bar']['title'],
		'title'         => $text['blocks']['progress-bar']['title'],
		'desc'          => $text['blocks']['progress-bar']['desc'],
		'docs_url'      => 'https://docs.cmblocks.com/progress-bar/',
		'live_demo_url' => 'https://cmblocks.com/progress-bar/#progressBar-demo'
	],
	[
		'icon'          => get_template_directory_uri() . '/vendor/codemanas/theme-info/img/countdown-icon.png',
		'alt'           => $text['blocks']['countdown']['title'],
		'title'         => $text['blocks']['countdown']['title'],
		'desc'          => $text['blocks']['countdown']['desc'],
		'docs_url'      => 'https://docs.cmblocks.com/countdown/',
		'live_demo_url' => 'https://cmblocks.com/cm-blocks/countdown-2/#countdown-demo'
	],
	[
		'icon'          => get_template_directory_uri() . '/vendor/codemanas/theme-info/img/counter-icon.png',
		'alt'           => $text['blocks']['counter']['title'],
		'title'         => $text['blocks']['counter']['title'],
		'desc'          => $text['blocks']['counter']['desc'],
		'docs_url'      => 'https://docs.cmblocks.com/counter/',
		'live_demo_url' => 'https://cmblocks.com/counter/#counter-demo'
	]
];
?>
<div class="tab-panel" data-tab="tab2">
    <div class="tab-section tab-section--cmblocks">
        <div class="tab-section-cmBLocks">
            <div class="tab-section-cmBLocks__wrapper">
                <div class="quick-setting__wrapper quick-setting__wrapper--design-library">
                    <div class="cm-theme-admin-design-library-tab__section">
                        <h2><?php echo esc_html( $text['intro']['title'] ); ?></h2>
                        <p class="cm-theme-admin-card-item__desc"><?php echo esc_html( $text['intro']['copy'] ); ?></p>
                        <a href="<?php echo esc_url( 'https://cmblocks.com/cm-blocks-design-library-v1-2-0/' ) ?>" target="_blank" class="body-btn-primary"><?php echo $text['learn_more']; ?></a>
                    </div>
                </div>
                <div class="cm-blocks-our-blocks">
                    <h2><?php echo $text['tab_title']; ?></h2>
                    <div class="quick-setting__wrapper">
						<?php foreach ( $items as $item ): ?>
                            <div class="cm-theme-admin-card-item">
                                <div class="cm-theme-admin-card-item__header">
                                    <h5 class="cm-theme-admin-card-item__title"><?php echo $item['title']; ?></h5>
                                    <img src="<?php echo esc_url( $item['icon'] ); ?>" alt="<?php echo $item['alt']; ?>">
                                </div>
                                <p class="cm-theme-admin-card-item__desc"><?php echo $item['desc']; ?></p>
                                <div class="cm-theme-admin-card-item-btn__wrapper">
                                    <a class="body-btn-primary" href="<?php echo esc_url( $item['docs_url'] ); ?>" target="_blank"><?php echo $text['docs']; ?></a>
                                    <a class="cm-theme-admin-btn-secondary" href="<?php echo esc_url( $item['live_demo_url'] ); ?>" target="_blank"><?php echo $text['demo_link']; ?></a>
                                </div>
                            </div>
						<?php endforeach; ?>
                    </div>
                </div>
            </div>
            <div class="cm-admin-tab__wrapper">
                <a href="<?php echo esc_url( 'https://cmblocks.com/pricing/' ) ?>" class="cm-admin-designLibrary__pro" target="_blank">
                    <h2><?php echo esc_html( $text['sidebar']['title'] ); ?></h2>
                    <p class="cm-admin-card-item__desc"><?php echo esc_html( $text['sidebar']['copy'] ); ?></p>
                    <button class="body-btn-primary"><?php echo $text['learn_more']; ?></button>
                </a>
            </div>
        </div>
    </div>
</div>