<?php
$intro_img            = apply_filters( 'codemanas_theme_info_intro_image', get_template_directory_uri() . '/screenshot.png' );
$i18n                 = \Codemanas\ThemeInfo\Translations::get_instance();
$translated_text      = $i18n->get_banner_translations();
$themeSettingInstance = $themeSettingInstance ?? null;
if ( ! $themeSettingInstance instanceof \Codemanas\ThemeInfo\ThemeSetting ) {
	wp_die( 'Error, please contact support' );
}
$plugin_file = $themeSettingInstance->codemanas_get_plugin_file( 'cm-blocks' );
include_once ABSPATH . 'wp-admin/includes/plugin.php';
$is_active    = is_plugin_active( $plugin_file );
$button_class = $is_active ? 'button plugins__card-button activated install-plugin' : 'button button-primary plugins__card-button install install-plugin';

?>
<div class="cm-admin-intro">
    <div class="cm-admin-intro__img">
        <img src="<?php echo esc_url( $intro_img ); ?>" alt="<?php echo esc_html( $translated_text['heading'] ); ?>">
    </div>
    <div class="cm-admin-intro__info">
        <h3><?php echo $translated_text['heading'] ?></h3>
        <h2><?php echo $translated_text['sub_heading'] ?></h2>
        <p class="desc"><?php echo $translated_text['copy']; ?></p>
        <div class="cm-admin-intro__buttons">
			<?php Codemanas\ThemeInfo\PluginInstaller::render_installer_button( 'cm-blocks', 'cm-blocks' ); ?>
            <a href="<?php echo esc_url( 'https://cmblocks.com/' ) ?>"
               class="body-btn-primary" target="_blank">
				<?php echo $translated_text['learn_more'] ?>
            </a>
        </div>
    </div>
</div>