<?php

namespace Codemanas\ThemeInfo;

use Plugin_Upgrader;
use WP_Ajax_Upgrader_Skin;

require_once ABSPATH . 'wp-admin/includes/plugin.php';
require_once ABSPATH . 'wp-admin/includes/file.php';
require_once ABSPATH . 'wp-admin/includes/plugin-install.php';
require_once ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';
require_once ABSPATH . 'wp-admin/includes/misc.php';

class PluginInstaller {
	private $pluginSlug;
	private $pluginFileName;

	public function __construct( $pluginSlug, $filename ) {
		$this->pluginSlug     = $pluginSlug;
		$this->pluginFileName = $filename;
	}

	public static function is_plugin_installed( $plugin_slug, $plugin_filename ) {
		//echo( WP_PLUGIN_DIR . '/' . $plugin_slug . '/' . $plugin_filename . '.php');
		return file_exists( WP_PLUGIN_DIR . '/' . $plugin_slug . '/' . $plugin_filename . '.php' );
	}

	public static function render_installer_button( $plugin_slug, $plugin_filename, $additional_classes = [] ) {
		$i18n         = Translations::get_instance()->get_general_tab();
		$is_installed = self::is_plugin_installed( $plugin_slug, $plugin_filename );
		$is_active    = is_plugin_active( $plugin_slug . '/' . $plugin_filename . '.php' );
		$buttonText   = $i18n['activated'];

		$default_class     = [ 'plugins__card-button', 'button', 'install-plugin' ];
		$conditional_class = ! $is_active
			? [ 'button-primary', 'install' ]
			: [ 'button-secondary' ];
		$buttonClass       = array_merge( $default_class, $conditional_class, $additional_classes );
		$classString       = implode( ' ', $buttonClass );
		if ( ! $is_installed ) {
			$buttonText = $i18n['install_and_activate'];
		} elseif ( ! $is_active ) {
			$buttonText = $i18n['activate'];
		}
		include_once get_template_directory() . '/vendor/codemanas/theme-info/css/loader-style.php';
		?>
        <button class="<?php echo esc_attr( $classString ) ?>"
                data-plugin="<?php echo esc_attr( $plugin_slug ) ?>"
			<?php echo $is_active ? esc_attr( 'disabled="disabled"' ) : '' ?>
                style="display:flex; gap: 0.15em; align-items:center; justify-content:center; flex-wrap:nowrap;"
        ><span class="text"><?php echo esc_html( $buttonText ); ?></span>
            <span class="cm-spinner"></span>
        </button>
		<?php
	}

	public function installAndActivate() {
		//check if it's already installed and activate
		if ( self::is_plugin_installed( $this->pluginSlug, $this->pluginFileName ) ) {
			return $this->activatePlugin();
		}


		if ( $this->isPluginActivated() ) {
			return 'Plugin is already installed / activated.';
		}

		$installationResult = $this->installPlugin();

		if ( is_wp_error( $installationResult ) ) {
			return 'Error installing the plugin: ' . $installationResult->get_error_message();
		}

		$activationResult = $this->activatePlugin();


		if ( is_wp_error( $activationResult ) ) {
			return 'Error activating the plugin: ' . $activationResult->get_error_message();
		}

		return 'Plugin installed and activated successfully.';
	}

	private function isPluginActivated() {
		return is_plugin_active( $this->pluginSlug . '/' . $this->pluginFileName . '.php' );
	}

	private function installPlugin() {
		$api = plugins_api(
			'plugin_information',
			array(
				'slug'   => $this->pluginSlug,
				'fields' => array(
					'short_description' => false,
					'sections'          => false,
					'requires'          => false,
					'tested'            => false,
					'downloaded'        => false,
					'download_link'     => true,
					'last_updated'      => false,
					'added'             => false,
				),
			)
		);

		if ( is_wp_error( $api ) ) {
			return $api;
		}

		$skin     = new WP_Ajax_Upgrader_Skin();
		$upgrader = new Plugin_Upgrader( $skin );

		return $upgrader->install( $api->download_link );
	}

	private function activatePlugin() {
		$activationResult = activate_plugin( $this->pluginSlug . '/' . $this->pluginFileName . '.php' );

		if ( is_wp_error( $activationResult ) ) {
			return $activationResult;
		}

		return true;
	}

}