// Immediately Invoked Function Expression for isolation
(() => {
  document.addEventListener('DOMContentLoaded', () => {
    // Variable declarations for tabs and panels
    const cmAdminTabs = document.querySelectorAll('.tab')
    const tabPanels = document.querySelectorAll('.tab-panel')

    const buttons = document.querySelectorAll('.install-plugin')

    // Attach click listeners to all tabs
    const initializeTabs = () => {
      cmAdminTabs.forEach((tab) => {
        tab.addEventListener('click', () => {
          showTab(tab.id)
        })
      })
    }

    // Function to show the selected tab
    const showTab = (tabId) => {
      cmAdminTabs.forEach((tab) => tab.classList.remove('active'))
      document.getElementById(tabId).classList.add('active')

      tabPanels.forEach((panel) => panel.classList.remove('active'))
      document.querySelector(`.tab-panel[data-tab="${tabId}"]`).classList.add('active')
    }

    // Initialize plugin installation buttons
    const initializePluginButtons = () => {
      buttons.forEach((button) => {
        button.addEventListener('click', () => handlePluginInstall(button))
      })
    }

    // Handle plugin installation
    const handlePluginInstall = (button) => {
      const pluginSlug = button.getAttribute('data-plugin')
      const nonce = cm_themeInfo.nonce // Retrieved nonce from localized script
      const { ajaxurl } = cm_themeInfo // Use destructuring for better readability

      if (!pluginSlug || !nonce || !ajaxurl) {
        console.error('Missing data attributes or cm_themeInfo values.')
        return
      }

      updateButtonState(button, 'Installing...')
      const body = new URLSearchParams({
        action: 'cm_theme_info_admin_install_plugin',
        plugin_slug: pluginSlug,
        nonce,
      })

      fetch(ajaxurl, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: body.toString(),
      }).then((response) => {
        if (!response.ok) {
          throw new Error(`Network response was not ok: ${response.status}`)
        }
        return response.json()
      }).then((data) => {
        if (data.success) {
          const feedback = data?.data
          updateButtonState(button, 'Activated', false)
          console.log(feedback)
          if (feedback?.plugin_slug === 'cm-blocks') {
            const basePath = '/wp-admin/admin.php'
            const params = new URLSearchParams({
              page: 'cm-blocks',
            })
            window.location.href = `${window.location.origin}${basePath}?${params.toString()}`;
          }
        } else {
          console.error(`Error: ${data.data.message}`)
          updateButtonState(button, 'Error')
        }
      }).catch((error) => {
        console.error('Fetch operation failed:', error)
        updateButtonState(button, `Error: ${error.message}`)
      })
    }

    // Update button state (utility function)
    const updateButtonState = (button, text, enableLoading = true) => {
      if (!button) return
      const textSpan = button.querySelector('.text')
      const spinner = button.querySelector('.cm-spinner')
      textSpan.innerText = text
      spinner.style.display = enableLoading ? 'inline-block' : 'none'
      if (text === 'Activated') {
        button.setAttribute('disabled', 'disabled')
      }
    }

    // Initialize all functionality
    const initialize = () => {
      initializeTabs()
      initializePluginButtons()
    }

    initialize()
  })
})()