<?php

namespace Codemanas\Canvas;

use Codemanas\ThemeInfo\ThemeSetting;

class Bootstrap {
	private static ?Bootstrap $_instance = null;

	public static function get_instance(): ?Bootstrap {
		return ( self::$_instance == null ) ? self::$_instance = new self() : self::$_instance;
	}

	private function __construct() {
		require get_template_directory() . '/vendor/autoload.php';
		$this->loadDependencies();
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
	}

	public function loadDependencies() {
		add_filter( 'cm_theme_info_translations', [ $this, 'setup_theme_info_translations' ] );
		ThemeSetting::get_instance();
	}

	public function enqueue_scripts() {
		wp_register_style( 'block-canvas', get_theme_file_uri( 'dist/assets/css/style' . '.css' ) );
		wp_enqueue_style( 'block-canvas' );
	}

	public function setup_theme_info_translations( $translations ): array {
		return array_merge( $translations, [
			'general'      => [
				'our_plugins'          => __( 'Our Plugins', 'block-canvas' ),
				'learn_more'           => __( 'Learn More', 'block-canvas' ),
				'demo_link'            => __( 'Live Demo', 'block-canvas' ),
				'documentation'        => __( 'See Documentation', 'block-canvas' ),
				'documentation_link'   => __( 'See Documentation', 'block-canvas' ),
				'install_and_activate' => __( 'Install and Activate', 'block-canvas' ),
				'activate'             => __( 'Activate', 'block-canvas' ),
				'activated'            => __( 'Activated', 'block-canvas' ),
				'support'              => __( 'Go to Support', 'block-canvas' ),
				'sticky_header_info'   => 'To enable sticky header please install and activate',
				'cm_blocks'            => 'CM Blocks',
			],
			'header'       => [
				'upgrade' => __( 'Upgrade to Pro', 'block-canvas' ),
			],
			'banner'       => [
				'heading'     => __( 'CM BLOCKS', 'block-canvas' ),
				'sub_heading' => __( 'Start with Simplicity, Grow with Ease.', 'block-canvas' ),
				'copy'        => __( 'Get started quickly with professionally designed starter sites, explore a rich design library of patterns and page layouts, and enjoy advanced features like Block Visibility, Scroll to Top, and Maintenance Mode. With intuitive, easy-to-use blocks, building beautiful, functional websites has never been simpler.', 'block-canvas' ),
				'link_text'   => __( 'Get started with CM Blocks', 'block-canvas' ),
			],
			'sidebar'      => [
				'help_and_support'   => __( 'Help & Support', 'block-canvas' ),
				'support_copy'       => __( 'Need a hand with something? We’re here for you! Just click the button below to find support options and helpful resources.', 'block-canvas' ),
				'documentation_copy' => __( 'Learn how to make the most of our products with our detailed documentation.', 'block-canvas' ),
				'leave_a_review'     => __( 'Leave a Review', 'block-canvas' ),
				'review_copy'        => __( 'Enjoy using our products? We’d love to hear your feedback.', 'block-canvas' ),
			],
			'tab_headings' => [
				'get_started' => __( 'Get Started', 'block-canvas' ),
				'cm_blocks'   => __( 'CM Blocks', 'block-canvas' ),
				'changelog'   => __( 'Change Log', 'block-canvas' ),
			],
			'general_tab'  => [
				'tab_title'      => __( 'Quick Settings', 'block-canvas' ),
				'quick_settings' => [
					'header'        => [
						'title' => __( 'Header', 'block-canvas' ),
						'desc'  => __( 'The header is a key section at the top of your site that can include your logo, site title, menu, or other important elements.', 'block-canvas' ),
					],
					'footer'        => [
						'title' => __( 'Footer', 'block-canvas' ),
						'desc'  => __( 'The footer is the section at the bottom of your site, often used to display credits, navigation links, or additional information.', 'block-canvas' ),
					],
					'global_styles' => [
						'title' => __( 'Global Styles', 'block-canvas' ),
						'desc'  => __( 'Global styles allows users to customize the overall appearance of their site, including typography, colors, and layouts, across all blocks and templates.', 'block-canvas' ),
					],
					'navigation'    => [
						'title' => __( 'Navigation', 'block-canvas' ),
						'desc'  => __( 'Navigation menus help users explore and move between different areas of the website.', 'block-canvas' ),
					],
					'templates'     => [
						'title' => __( 'Templates', 'block-canvas' ),
						'desc'  => __( 'Templates define the overall layout and structure of your pages and posts, determining how content is displayed.', 'block-canvas' ),
					],
					'patterns'      => [
						'title' => __( 'Patterns', 'block-canvas' ),
						'desc'  => __( 'Patterns are predefined block layouts that help you quickly design and organize content on your WordPress site with ease.', 'block-canvas' ),
					],
				],
				'plugins'        => [
					'zoom'         => [
						'title' => __( 'Video Conferencing with Zoom', 'block-canvas' ),
						'desc'  => __( 'Manage Zoom meetings and webinars effortlessly from your WordPress dashboard.', 'block-canvas' ),
					],
					'typesense'    => [
						'title' => __( 'Search with Typesense', 'block-canvas' ),
						'desc'  => __( 'Turbocharge your site’s search with Typesense. Get lightning-fast search at your fingertips.', 'block-canvas' ),
					],
					'simple_popup' => [
						'title' => __( 'Simple Popup Block', 'block-canvas' ),
						'desc'  => __( 'The easy way to manage popups on your website. Enjoy enhanced engagement without sacrificing page speed.', 'block-canvas' ),
					],
				],
			],
			'blocks_tab'   => [
				'docs'      => __( 'Docs', 'block-canvas' ),
				'tab_title' => __( 'Blocks', 'block-canvas' ),
				'intro'     => [
					'title' => __( 'Craft Your Distinctive Web Presence', 'block-canvas' ),
					'copy'  => __( 'Explore our extensive collection of expertly crafted patterns and page designs. Choose from a variety of options to create your site exactly as you envision it.

With just a few clicks, easily create beautiful sections anywhere on your site.', 'block-canvas' ),
				],
				'sidebar'   => [
					'title' => __( 'Elevate your design', 'block-canvas' ),
					'copy'  => __( 'Unlock premium designs and access a collection of unique, high-quality templates that will make your site stand out. With dedicated priority support, you will have everything you need to create exceptional websites effortlessly. Elevate your design capabilities today with our Premium Designs!', 'block-canvas' ),
				],
				'blocks'    => [
					'slider'          => [
						'title' => __( 'Slider', 'block-canvas' ),
						'desc'  => __( 'Use the Slider block to display content such as images, testimonials, or promotions, with smooth transitions that engage users interactively.', 'block-canvas' ),
					],
					'accordion'       => [
						'title' => __( 'Accordion', 'block-canvas' ),
						'desc'  => __( 'Use the Accordion block to present content in expandable sections, making it easy for users to access detailed information without cluttering the page.', 'block-canvas' ),
					],
					'progress-bar'    => [
						'title' => __( 'Progress Bar', 'block-canvas' ),
						'desc'  => __( 'Use the Progress Bar block to visually represent the completion of a task, goal, or process, offering clear feedback to users.', 'block-canvas' ),
					],
					'countdown'       => [
						'title' => __( 'Countdown', 'block-canvas' ),
						'desc'  => __( 'Use the Countdown block to count down to a specific date or event, creating a sense of anticipation and urgency.', 'block-canvas' ),
					],
					'counter'         => [
						'title' => __( 'Counter', 'block-canvas' ),
						'desc'  => __( 'Use the Counter block to display a numerical value that can increase or decrease, perfect for showing stats or interactive data.', 'block-canvas' ),
					],
					'masonry-gallery' => [
						'title' => __( 'Masonry Gallery', 'block-canvas' ),
						'desc'  => __( 'Use the Masonry Gallery block to create a dynamic, grid-based layout for images or content, adjusting to different sizes and creating an organized yet creative display.', 'block-canvas' ),
					],
				],
			],
		] );
	}
}

Bootstrap::get_instance();