<?php
/*
BirdFLAT functions and definitions.
*/
//////////////////////////////////////////
// Set the content width based on the theme's design and stylesheet.
if ( ! isset( $content_width ) )
	$content_width = 585;

//////////////////////////////////////////
// Set Widgets
function birdflat_widgets_init() {

	register_sidebar( array (
		'name' => __('Widget Area for sidebar', 'birdflat'),
		'id' => 'widget-area-sidebar',
		'description' => __('Widget Area for sidebar', 'birdflat'),
		'before_widget' => '<div class="widget">',
		'after_widget' => '</div>',
		'before_title' => '<h3>',
		'after_title' => '</h3>',
		) );

	register_sidebar( array (
		'name' => __('Widget Area for footer', 'birdflat'),
		'id' => 'widget-area-footer',
		'description' => __('Widget Area for footer', 'birdflat'),
		'before_widget' => '<div class="widget">',
		'after_widget' => '</div>',
		'before_title' => '<h3>',
		'after_title' => '</h3>',
		) );
}
add_action( 'widgets_init', 'birdflat_widgets_init' );  

//////////////////////////////////////////
// SinglePage Comment callback
function birdflat_custom_comments( $comment, $args, $depth ) {

	$GLOBALS['comment'] = $comment;

?>
	<li <?php comment_class(); ?> id="comment-<?php comment_ID(); ?>">

	<?php if('pingback' == $comment->comment_type || 'trackback' == $comment->comment_type):
		$birstips_url    = get_comment_author_url();
		$birstips_author = get_comment_author();
	 ?> 

		<div class="posted"><strong><?php _e( 'Pingback', 'birdflat' ); ?> : </strong><a href="<?php echo $birstips_url; ?>" target="_blank"><?php echo $birstips_author ?></a><?php edit_comment_link( __('(Edit)', 'birdflat'), ' ' ); ?></div>

	<?php else: ?>

		<div class="comment_meta">
			<?php echo get_avatar( $comment, 40 ); ?>
			<span class="author"><?php comment_author(); ?></span>
			<span class="time"><?php echo get_comment_time(get_option('date_format') .' ' .get_option('time_format')); ?></span>
			<span class="reply"><?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?></span>
		</div>
		<?php if ( $comment->comment_approved == '0' ) : ?>
			<em><?php _e( 'Your comment is awaiting moderation.', 'birdflat' ); ?></em><br>
		<?php endif; ?>

		<div class="comment_text">
			<?php comment_text(); ?>

			<?php $birdflat_web = get_comment_author_url(); ?>
			<?php if(!empty($birdflat_web)): ?>
				<p class="web"><a href="<?php echo $birdflat_web; ?>" target="_blank"><?php echo $birdflat_web; ?></a></p>
			<?php endif; ?>
		</div>

	<?php endif; ?>
<?php
	// no "</li>" conform WORDPRESS
}

//////////////////////////////////////////////////////
// Pagenation
function birdflat_the_pagenation() {

	global $wp_rewrite;
	global $wp_query;
	global $paged;

	$birdflat_paginate_base = get_pagenum_link(1);
	if (strpos($birdflat_paginate_base, '?') || ! $wp_rewrite->using_permalinks()) {
		$birdflat_paginate_format = '';
		$birdflat_paginate_base = add_query_arg('paged', '%#%');
	} else {
		$birdflat_paginate_format = (substr($birdflat_paginate_base, -1 ,1) == '/' ? '' : '/') .
		user_trailingslashit('page/%#%/', 'paged');;
		$birdflat_paginate_base .= '%_%';
	}
	echo paginate_links( array(
		'base' => $birdflat_paginate_base,
		'format' => $birdflat_paginate_format,
		'total' => $wp_query->max_num_pages,
		'mid_size' => 3,
		'current' => ($paged ? $paged : 1),
	));
}

//////////////////////////////////////////////////////
// Search form
function birdflat_search_form( $form ) {

	$birdflat_search_string = '';
	if(is_search()){
		$birdflat_search_string = get_search_query();
	}

	$birdflat_form = '<form method="get" id="searchform" action="' .home_url( '/' ) .'">
	<div id="qsearch">
		<input type="text" name="s" id="s" value="' .$birdflat_search_string .'">
		<input class="btn" alt="' .__('Search', 'birdflat') .'" type="submit" id="searchsubmit" value="' . __('Search', 'birdflat') .'" onClick="void(this.form.submit());return false;">
	</div></form>';

    return $birdflat_form;
}
add_filter( 'get_search_form', 'birdflat_search_form' );

//////////////////////////////////////////
// Archive PageTitle
function birdflat_the_archivetitle() {

	if(is_category()) {
		printf(__('Category Archives: %s', 'birdflat'), single_cat_title('', false));
	}
	elseif( is_tag() ) {
		printf(__('Tag Archives: %s', 'birdflat'), single_tag_title('', false) );
	}
	elseif (is_day()) {
		printf(__('Daily Archives: %s', 'birdflat'), get_post_time(get_option('date_format')));
	}
	elseif (is_month()) {
		printf(__('Monthly Archives: %s', 'birdflat'), get_post_time(__('F, Y', 'birdflat')));
	}
	elseif (is_year()) {
		printf(__('Yearly Archives: %s', 'birdflat'), get_post_time(__('Y', 'birdflat')));
	}
	elseif (is_author()) {
		printf(__('Author Archives: %s', 'birdflat'), get_the_author_meta('display_name', get_query_var('author')) );
	}
	elseif (isset($_GET['paged']) && !empty($_GET['paged'])) {
		_e('Blog Archives', 'birdflat');
	}
}

//////////////////////////////////////////////////////
// Header Style
function birdflat_header_style() {

?>

<style type="text/css">

<?php

	//Theme Option
	$header_color = get_theme_mod( 'birdflat_header_color', '#FC7E74');
	$meta_color = get_theme_mod( 'birdflat_meta_color', '#9CB2C4');
	$link_color = get_theme_mod( 'birdflat_link_color', '#0000AA');
	$text_color = get_theme_mod( 'birdflat_text_color', '#544021');
	

	if ( 'blank' == get_header_textcolor() ) { ?>
		#header #site-title,
		#header #site-description {
			position: absolute !important;
			clip: rect(1px 1px 1px 1px); /* IE6, IE7 */
			clip: rect(1px, 1px, 1px, 1px);
			}   
		#header #branding {
			padding: 0;
			}
	<?php } else { ?>

		#header #branding #site-title,
		#header #branding #site-title a,
		#header #branding p#site-description,
		#menu-wrapper .menu ul#menu-primary-items > li > a {
			color: #<?php header_textcolor();?>;
		}

	<?php } ?>


	#wrapper,
	#content .hentry .entry-header .entry-title a,
	.widget #wp-calendar th, .widget #wp-calendar td,
	#menu-wrapper .menu ul li ul li a {
		color: <?php echo $text_color;?>;
	}

	a,
	#content .hentry .page-link,
	#content .hentry .page-link a,
	#content .tablenav a.page-numbers,
	.widget #wp-calendar td a {
		color: <?php echo $link_color;?>;
	}

	#content .hentry .page-link a,
	#content .tablenav a.page-numbers,
	#content .tablenav .current {
		border-color: <?php echo $link_color;?>;
	}

	#content .tablenav .current {
		background-color: <?php echo $link_color;?>;
	}

	#header,
	#footer,
	#content .hentry.sticky .entry-meta {
		background: <?php echo $header_color;?>;
	}

	#sidebar .widget h3 {
		color: <?php echo $meta_color;?>;
		border-color: <?php echo $meta_color;?>;
	}

	#content .hentry .entry-meta,
	.widget form#searchform #qsearch .btn {
		background-color: <?php echo $meta_color;?>;
	}

	@media screen and (max-width: 615px) {
		#menu-wrapper .menu ul#menu-primary-items > li > a {
			color: <?php echo $text_color;?>;
		}

		#menu-wrapper .menu #small-menu {
			border-color: #<?php header_textcolor();?>;
		}

		#menu-wrapper .menu #small-menu .icon-bar {
			background-color: #<?php header_textcolor();?>;
		}
	}

</style>

<?php 

}

//////////////////////////////////////////////////////
// Admin Header Style
function birdflat_admin_header_style() {

	$header_color = get_theme_mod( 'birdflat_header_color', '#fc7e74');
?>

<style type="text/css">

	#birdflat_header img {
		width: <?php echo HEADER_IMAGE_WIDTH; ?>px;
		height: <?php echo HEADER_IMAGE_HEIGHT; ?>px;
	}

	#birdflat_header {
		background: <?php echo $header_color;?>;
		padding: 0 0 20px;
	}

	#birdflat_header #branding {
		padding: 2em 0 1em;
	}

	#birdflat_header #site-title {
		margin: 0;
		padding: 0;
		color: #FFF;
		font-size: 2.8em;
		line-height: 1;
		color: #<?php header_textcolor();?>;
	}

	#birdflat_header #site-title a {
		color: #FFF;
    	font-weight: bold;
		text-decoration: none;
		color: #<?php header_textcolor();?>;
	}

	#birdflat_header #site-description {
		margin: 0.5em 0;
		color: #<?php header_textcolor();?>;
	}

</style>

<?php

} 

//////////////////////////////////////////////////////
// Admin Header Image
function birdflat_admin_header_image() {

	$header_image = get_header_image();
	$birdflat_image_tag = '';
	if ( empty( $header_image ) ){
		$birdflat_image_tag = ' class="no-image"'; 
	}

	$style = '';
		if ( 'blank' == get_theme_mod( 'header_textcolor', HEADER_TEXTCOLOR ) || '' == get_theme_mod( 'header_textcolor', HEADER_TEXTCOLOR ) ){
		$style = ' style="display:none;"';
	}
?>
	<div id="birdflat_header"<?php echo $birdflat_image_tag; ?>>

		<?php $header_image = get_header_image();
			if ( ! empty( $header_image ) ) : ?>
			<img src="<?php echo esc_url( $header_image ); ?>" alt="" />
		<?php endif; ?>

		<div id="branding">
			<div id="site-title"><a <?php echo $style; ?> onclick="return false;" href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php bloginfo( 'name' ); ?></a></div>
			<div id="site-description" <?php echo $style; ?>><?php bloginfo( 'description' ); ?></div>
		</div>
	</div>
	<?php
}

//////////////////////////////////////////////////////
// Setup Theme
function birdflat_setup() {

	// Set languages
	load_theme_textdomain( 'birdflat', get_template_directory() . '/languages' );

	// This theme styles the visual editor with editor-style.css to match the theme style.
	add_editor_style();

	// Set feed
	add_theme_support( 'automatic-feed-links' );

	// This theme uses post thumbnails
	add_theme_support( 'post-thumbnails' );

	/*
	 * This theme supports custom background color and image, and here
	 * we also set up the default background color.
	 */
	add_theme_support( 'custom-background', array(
		'default-color' => 'EFEFEF',
	) );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => __( 'Primary Navigation', 'birdflat' ),
	) );

	// Add support for custom headers.
	$custom_header_support = array(
		'width' => apply_filters( 'birdflat_header_image_width', 930 ),
		'height' => apply_filters( 'birdflat_header_image_height', 200 ),
		'default-text-color'     => 'FFF',
		'wp-head-callback' => 'birdflat_header_style',
		'admin-head-callback' => 'birdflat_admin_header_style',
		'admin-preview-callback' => 'birdflat_admin_header_image'
	);

	add_theme_support( 'custom-header', $custom_header_support );
}
add_action( 'after_setup_theme', 'birdflat_setup' );  

//////////////////////////////////////////////////////
// Document Title
function birdflat_title( $title ) {
	global $page, $paged;

	$title .= get_bloginfo( 'name' );
	$site_description = get_bloginfo( 'description', 'display' );

	if ( $site_description && ( is_home() || is_front_page() ) )
		$title .= " | $site_description";

	if ( $paged >= 2 || $page >= 2 )
		$title .= ' | ' . sprintf( __( 'Page %s', 'birdflat' ), max( $paged, $page ) );

	return $title;
}
add_filter( 'wp_title', 'birdflat_title' );

//////////////////////////////////////////////////////
// Enqueue Acripts
function birdflat_scripts() {

	if ( is_singular() && comments_open() && get_option('thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	wp_enqueue_script('jquery');
	wp_enqueue_script('jquery-masonry');
	wp_enqueue_script( 'birdflat', get_template_directory_uri() .'/js/birdflat.js', 'jquery', '1.03' );
	wp_enqueue_style( 'birdflat', get_stylesheet_uri() );
}
add_action( 'wp_enqueue_scripts', 'birdflat_scripts' );

//////////////////////////////////////////////////////
// Excerpt More
function birdflat_excerpt_more($more) { 
	return ' <a href="'. esc_url( get_permalink() ) . '">' . __( '&raquo;more', 'birdflat') . '</a>';
}  
add_filter('excerpt_more', 'birdflat_excerpt_more'); 

//////////////////////////////////////////////////////
// Theme Customizer
function birdflat_customize($wp_customize) {
 
	$wp_customize->add_section( 'birdflat_customize', array(
		'title'=> __( 'Theme Options', 'birdflat' ),
		'priority' => 99,
	) );

	// Text Color
	$wp_customize->add_setting( 'birdflat_text_color', array(
		'default' => '#544021',
	) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'birdflat_text_color', array(
		'label' => __( 'Text Color', 'birdflat' ),
		'section'=> 'birdflat_customize',
		'settings' => 'birdflat_text_color',
	) ) );

	// Link Color
	$wp_customize->add_setting( 'birdflat_link_color', array(
		'default' => '#00A',
	) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'birdflat_link_color', array(
		'label' => __( 'Link Color', 'birdflat' ),
		'section'=> 'birdflat_customize',
		'settings' => 'birdflat_link_color',
	) ) );

	// Header, Footer Background Color
	$wp_customize->add_setting( 'birdflat_header_color', array(
		'default' => '#FC7E74',
	) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'birdflat_header_color', array(
		'label' => __( 'Header, Footer Background Color', 'birdflat' ),
		'section'=> 'birdflat_customize',
		'settings' => 'birdflat_header_color',
	) ) );

	// Post Footer Background Color
	$wp_customize->add_setting( 'birdflat_meta_color', array(
		'default' => '#9CB2C4',
	) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'birdflat_meta_color', array(
		'label' => __( 'Post Footer Background Color', 'birdflat' ),
		'section'=> 'birdflat_customize',
		'settings' => 'birdflat_meta_color',
	) ) );

}
add_action('customize_register', 'birdflat_customize');
