<?php
/*
The default template for displaying content. Used for both single and index/page/archive/search.
*/
?>

<?php if(is_singular()): // Display Excerpts for Single/Page ?>
	<header class="entry-header">
		<h1 class="entry-title"><?php the_title(); ?></h1>
	</header>

	<div class="entry-content">
		<?php the_content(); ?>
		<?php wp_link_pages( array( 'before' => '<div class="page-link">' . __( 'Pages:', 'birdflat' ), 'after' => '</div>' ) ); ?>
	</div>

	<?php if(is_single()): // Only Display Excerpts for Single ?>
		<footer class="entry-meta">
			<?php if(is_single()): // Only Display Excerpts for Single ?>
				<span class="author"><time class="postdate" datetime="<?php echo get_the_time('Y-m-d') ?>" pubdate><?php echo get_post_time(get_option('date_format')); ?></time> <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author(); ?></a></span>
		<?php endif; ?>
			
			<span><?php _e( 'Posted in', 'birdflat' ); ?>: <?php the_category(', ') ?></span>
			<?php the_tags('<span class="tag">' .__( 'Tagged', 'birdflat' ) .': ', ', ', '</span>') ?>
			
		</footer>
	<?php endif; ?>

<?php else: /* Display Excerpts for Home, Archive */ ?>
	<li id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<div class="entry-inner">
		<?php if(has_post_thumbnail()): ?>
			<div class="entry-eyecatch"><a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('large'); ?></a></div>
		<?php endif; ?>

		<header class="entry-header">
			<h2 class="entry-title"><a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', 'birdflat' ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark"><?php the_title(); ?></a></h2>
		</header><!-- .entry-header -->
		<div class="entry-content">
			<?php if (is_sticky()):
				the_content( );
			else:
				the_excerpt( );
			endif; ?>
			<?php wp_link_pages( array( 'before' => '<div class="page-link">' . __( 'Pages:', 'birdflat' ), 'after' => '</div>' ) ); ?>
		</div><!-- .entry-content -->
		</div><!-- .entry-inner -->

		<footer class="entry-meta">
			<span class="author"><a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', 'birdflat' ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark" class="postdate"><time datetime="<?php echo get_the_time('Y-m-d') ?>" pubdate><?php echo get_post_time(get_option('date_format')); ?></time></a> <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>" class="author"><?php the_author(); ?></a></span>
			<span class="category"><?php _e( 'Posted in', 'birdflat' ); ?>: <?php the_category(', ') ?></span>
			<?php if ( comments_open() ) : ?>
				<span class="comments"><?php comments_popup_link(__('No Comments', 'birdflat'), __('1 Comment', 'birdflat'), __('% Comments', 'birdflat'), '', __('Comments Closed', 'birdflat') ); ?></span>
			<?php endif; ?>
			
		</footer><!-- .entry-meta -->
	</li><!-- #post -->

<?php endif; ?>
