<?php

/**
 * [best_responsive_setup code for after_setup_theme hook]
 * @return [type] [description]
 */
function best_responsive_setup() {

	// Register Overlay Menu
	register_nav_menus( array(
		'overlaymenu'	=> __( 'Overlay Menu', 'best-responsive' ),
	) );


}
add_action( 'after_setup_theme', 'best_responsive_setup' );

/**
 * [best_responsive_styles_scripts - add needed styles scripts]
 * @return [type] [description]
 */
function best_responsive_styles_scripts() {

	$dependency = array( 'bootstrap', 'font-awesome', 'di-responsive-style-default', 'di-responsive-style-core' );
	if( class_exists( 'WooCommerce' ) ) {
		$dependency = array( 'bootstrap', 'font-awesome', 'di-responsive-style-default', 'di-responsive-style-core', 'di-responsive-style-woo' ); 
	}

	/**
	 * Add the default/main css file of parent theme.
	 */
    wp_enqueue_style( 'di-responsive-style-default', get_template_directory_uri() . '/style.css' );

    /**
	 * Add the main css file of the child theme after all css files of parent theme.
	 */
    wp_enqueue_style( 'best-responsive',  get_stylesheet_directory_uri() . '/style.css', $dependency, wp_get_theme()->get('Version'), 'all' );

    // Load overlay-menu.js if overlay menu enabled in customize and enabled top bar
    if( get_theme_mod( 'display_top_bar', '0' ) == 1 && get_theme_mod( 'ovrly_menu_endis', '0' ) == 1 ) {
    	wp_enqueue_script( 'best-responsive-overlay-menu', get_stylesheet_directory_uri() . '/assets/js/overlay-menu.js', array( 'jquery' ), wp_get_theme()->get('Version'), true );
    }
}
add_action( 'wp_enqueue_scripts', 'best_responsive_styles_scripts' );


/**
 * [best_responsive_customize_pr_handle description]
 * @return [type] [description]
 */
function best_responsive_customize_pr_handle( $wp_customize ) {

	// For CTA
	$wp_customize->get_setting( 'cta_endis' )->transport   = 'refresh';
	$wp_customize->selective_refresh->add_partial( 'cta_endis', array(
		'selector'	=> '.di-cta',
	) );

}
add_action( 'customize_register', 'best_responsive_customize_pr_handle', 9999999 );


/**
 * [best_responsive_cta_options - Customize options]
 * @return [type] [description]
 */
function best_responsive_cta_options() {

	// CTA
	Kirki::add_section( 'cta', array(
		'title'          => esc_html__( 'CTA Options', 'best-responsive' ),
		'panel'          => 'di_responsive_options',
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'di_responsive_config', array(
		'type'        => 'toggle',
		'settings'    => 'cta_endis',
		'label'       => esc_html__( 'CTA Feature', 'best-responsive' ),
		'description' => esc_html__( 'Turn on to enable CTA', 'best-responsive' ),
		'section'     => 'cta',
		'default'     => '1',
	) );

	Kirki::add_field( 'di_responsive_config', array(
		'type'			=> 'text',
		'settings'		=> 'cta_label',
		'label'			=> esc_html__( 'Label', 'best-responsive' ),
		'description' 	=> esc_html__( 'Label of CTA', 'best-responsive' ),
		'section'		=> 'cta',
		'default'		=> esc_html__( 'Get Now!', 'best-responsive' ),
		'active_callback'  => array(
			array(
				'setting'  => 'cta_endis',
				'operator' => '==',
				'value'    => '1',
			),
		),
	) );

	Kirki::add_field( 'di_responsive_config', array(
		'type'			=> 'url',
		'settings'		=> 'cta_link',
		'label'			=> esc_html__( 'Link', 'best-responsive' ),
		'description' 	=> esc_html__( 'Link of CTA', 'best-responsive' ),
		'section'		=> 'cta',
		'default'		=> esc_url( home_url( '/' ) ),
		'active_callback'  => array(
			array(
				'setting'  => 'cta_endis',
				'operator' => '==',
				'value'    => '1',
			),
		),
	) );

	Kirki::add_field( 'di_responsive_config', array(
		'type'        => 'toggle',
		'settings'    => 'cta_link_trgt',
		'label'       => esc_html__( 'Link Target', 'best-responsive' ),
		'description' => esc_html__( 'Turn on to open link in new tab.', 'best-responsive' ),
		'section'     => 'cta',
		'default'     => '0',
		'active_callback'  => array(
			array(
				'setting'  => 'cta_endis',
				'operator' => '==',
				'value'    => '1',
			),
		),
	) );

	Kirki::add_field( 'di_responsive_config', array(
		'type'        => 'typography',
		'settings'    => 'cta_typog',
		'label'       => esc_html__( 'Typography', 'best-responsive' ),
		'description' => esc_html__( 'Typography of the CTA', 'best-responsive' ),
		'section'     => 'cta',
		'default'     => array(
			'font-family'    => 'Lora',
			'variant'        => '600italic',
			'font-size'      => '18px',
			'letter-spacing' => '1px',
			'text-transform' => 'capitalize',
			'color' 		 => '#ffffff',
		),
		'output'      => array(
			array(
				'element' => '.di-cta',
			),
		),
		'transport' => 'auto',
		'active_callback'  => array(
			array(
				'setting'  => 'cta_endis',
				'operator' => '==',
				'value'    => '1',
			),
		),
	) );

	Kirki::add_field( 'di_responsive_config', array(
		'type'        => 'color',
		'settings'    => 'cta_hvr_clr',
		'label'       => esc_html__( 'Hover Color', 'best-responsive' ),
		'description' => esc_html__( 'Hover color of the CTA', 'best-responsive' ),
		'section'     => 'cta',
		'default'     => '#cea525',
		'choices'     => array(
			'alpha' => true,
		),
		'output' => array(
			array(
				'element'	=> '.di-cta:hover, .di-cta:focus',
				'property'	=> 'color',
			),
		),
		'transport' => 'auto',
		'active_callback'  => array(
			array(
				'setting'  => 'cta_endis',
				'operator' => '==',
				'value'    => '1',
			),
		),
	) );

	Kirki::add_field( 'di_responsive_config', array(
		'type'        => 'color',
		'settings'    => 'cta_bg_clr',
		'label'       => esc_html__( 'Background Color', 'best-responsive' ),
		'description' => esc_html__( 'Background color of the CTA', 'best-responsive' ),
		'section'     => 'cta',
		'default'     => '#cea525',
		'choices'     => array(
			'alpha' => true,
		),
		'output' => array(
			array(
				'element'	=> '.di-cta',
				'property'	=> 'background-color',
			),
		),
		'transport' => 'auto',
		'active_callback'  => array(
			array(
				'setting'  => 'cta_endis',
				'operator' => '==',
				'value'    => '1',
			),
		),
	) );

	Kirki::add_field( 'di_responsive_config', array(
		'type'        => 'color',
		'settings'    => 'cta_hver_bg_clr',
		'label'       => esc_html__( 'Hover Background Color', 'best-responsive' ),
		'description' => esc_html__( 'Hover background color of the CTA', 'best-responsive' ),
		'section'     => 'cta',
		'default'     => '#000000',
		'choices'     => array(
			'alpha' => true,
		),
		'output' => array(
			array(
				'element'	=> '.di-cta:hover',
				'property'	=> 'background-color',
			),
		),
		'transport' => 'auto',
		'active_callback'  => array(
			array(
				'setting'  => 'cta_endis',
				'operator' => '==',
				'value'    => '1',
			),
		),
	) );

}
add_action( 'di_responsive_sec_aftr_typog', 'best_responsive_cta_options' );

/**
 * [best_responsive_overlaymenu - Customize options]
 * @return [type] [description]
 */
function best_responsive_overlaymenu() {

	Kirki::add_field( 'di_responsive_config', array(
		'type'        => 'toggle',
		'settings'    => 'ovrly_menu_endis',
		'label'       => esc_html__( 'Overlay Menu', 'best-responsive' ),
		'description' => esc_html__( 'Turn on to enable Overlay menu. you can create or select menu, here: Dashboard > Appearance > Menus', 'best-responsive' ),
		'section'     => 'top_bar',
		'default'     => '0',
		'active_callback'  => array(
			array(
				'setting'  => 'display_top_bar',
				'operator' => '==',
				'value'    => 1,
			),
		)
	) );

	Kirki::add_field( 'di_responsive_config', array(
		'type'			=> 'text',
		'settings'		=> 'ovrly_menu_ttl_attr',
		'label'			=> esc_html__( 'Title', 'best-responsive' ),
		'description' 	=> esc_html__( 'Title of the overlay menu icon', 'best-responsive' ),
		'section'		=> 'top_bar',
		'default'		=> esc_html__( 'Overlay Menu', 'best-responsive' ),
		'active_callback'  => array(
			array(
				'setting'  => 'display_top_bar',
				'operator' => '==',
				'value'    => 1,
			),
			array(
				'setting'  => 'ovrly_menu_endis',
				'operator' => '==',
				'value'    => '1',
			),
		),
	) );

	Kirki::add_field( 'di_responsive_config', array(
		'type'        => 'color',
		'settings'    => 'ovrly_menu_clr',
		'label'       => esc_html__( 'Links Color', 'best-responsive' ),
		'description' => esc_html__( 'Color of the overlay menu items', 'best-responsive' ),
		'section'     => 'top_bar',
		'default'     => '#818181',
		'choices'     => array(
			'alpha' => true,
		),
		'output' => array(
			array(
				'element'	=> 'ul.overlaymenu-class li a, .ovrly .ovrly-menu-closebtn',
				'property'	=> 'color',
			),
		),
		'transport' => 'auto',
		'active_callback'  => array(
			array(
				'setting'  => 'display_top_bar',
				'operator' => '==',
				'value'    => 1,
			),
			array(
				'setting'  => 'ovrly_menu_endis',
				'operator' => '==',
				'value'    => '1',
			),
		),
	) );

	Kirki::add_field( 'di_responsive_config', array(
		'type'        => 'color',
		'settings'    => 'ovrly_menu_hvr_clr',
		'label'       => esc_html__( 'Hover Links Color', 'best-responsive' ),
		'description' => esc_html__( 'Hover color of the overlay menu items', 'best-responsive' ),
		'section'     => 'top_bar',
		'default'     => '#f1f1f1',
		'choices'     => array(
			'alpha' => true,
		),
		'output' => array(
			array(
				'element'	=> 'ul.overlaymenu-class li a:hover, ul.overlaymenu-class li a:focus, .ovrly .ovrly-menu-closebtn:hover, .ovrly .ovrly-menu-closebtn:focus',
				'property'	=> 'color',
			),
		),
		'transport' => 'auto',
		'active_callback'  => array(
			array(
				'setting'  => 'display_top_bar',
				'operator' => '==',
				'value'    => 1,
			),
			array(
				'setting'  => 'ovrly_menu_endis',
				'operator' => '==',
				'value'    => '1',
			),
		),
	) );

	Kirki::add_field( 'di_responsive_config', array(
		'type'        => 'background',
		'settings'    => 'ovrly_menu_bg',
		'label'       => esc_html__( 'Overlay Menu Background Property', 'best-responsive' ),
		'description' => esc_html__( 'Display background color or image.', 'best-responsive' ),
		'section'     => 'top_bar',
		'default'     => array(
			'background-color'      => 'rgba(0,0,0, 0.8)',
			'background-image'      => '',
			'background-repeat'     => 'repeat',
			'background-position'   => 'center center',
			'background-size'       => 'cover',
			'background-attachment' => 'fixed',
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element' => '.ovrly',
			),
		),
		'active_callback'  => array(
			array(
				'setting'  => 'display_top_bar',
				'operator' => '==',
				'value'    => 1,
			),
			array(
				'setting'  => 'ovrly_menu_endis',
				'operator' => '==',
				'value'    => '1',
			),
		),
	) );

	Kirki::add_field( 'di_responsive_config', array(
		'type'        => 'color',
		'settings'    => 'ovrly_menu_bg_overlay',
		'label'       => esc_html__( 'Background Image Overlay Color', 'best-responsive' ),
		'description' => esc_html__( 'This color will apply over the background image.', 'best-responsive' ),
		'section'     => 'top_bar',
		'default'     => '',
		'choices'     => array(
			'alpha' => true,
		),
		'output' => array(
			array(
				'element'  => '.overlay-bgoverlay-color',
				'property' => 'background-color',
			),
		),
		'transport' => 'auto',
		'active_callback'  => array(
			array(
				'setting'  => 'display_top_bar',
				'operator' => '==',
				'value'    => 1,
			),
			array(
				'setting'  => 'ovrly_menu_endis',
				'operator' => '==',
				'value'    => '1',
			),
		),
	) );

	Kirki::add_field( 'di_responsive_config', array(
		'type'        => 'typography',
		'settings'    => 'ovrly_menu_typog',
		'label'       => esc_html__( 'Overlay Menu Typography', 'best-responsive' ),
		'description' => esc_html__( 'Typography of the overlay menu items', 'best-responsive' ),
		'section'     => 'top_bar',
		'default'     => array(
			'font-family'    => 'Lora',
			'variant'        => 'regular',
			'font-size'      => '26px',
			'letter-spacing' => '0px',
			'text-transform' => 'none',
		),
		'output'      => array(
			array(
				'element' => 'ul.overlaymenu-class li',
			),
		),
		'transport' => 'auto',
		'active_callback'  => array(
			array(
				'setting'  => 'display_top_bar',
				'operator' => '==',
				'value'    => 1,
			),
			array(
				'setting'  => 'ovrly_menu_endis',
				'operator' => '==',
				'value'    => '1',
			),
		),
	) );
}
add_action( 'di_responsive_top_bar_search_form', 'best_responsive_overlaymenu' );
