<?php
/**
 * Describe child theme functions
 *
 * @package Azure News
 * @subpackage Azure Blogger
 * @since 1.0.0
 */

/*------------------------- Theme Version -------------------------------------*/

	if ( ! defined( 'AZURE_BLOGGER_VERSION' ) ) {
		// Replace the version number of the theme on each release.
		$azure_blogger_theme_info = wp_get_theme();
		define( 'AZURE_BLOGGER_VERSION', $azure_blogger_theme_info->get( 'Version' ) );
	}

/*------------------------- Google Fonts --------------------------------------*/

	if ( ! function_exists( 'azure_blogger_fonts_url' ) ) :

	    /**
	     * Register Google fonts
	     *
	     * @return string Google fonts URL for the theme.
	     */
	    function azure_blogger_fonts_url() {

	        $fonts_url = '';
	        $font_families = array();

	        /*
	         * Translators: If there are characters in your language that are not supported
	         * by Bitter , translate this to 'off'. Do not translate into your own language.
	         */
	        if ( 'off' !== _x( 'on', 'Bitter font: on or off', 'azure-blogger' ) ) {
	            $font_families[] = 'Bitter :500,600,700,900';
	        }

	         /*
	         * Translators: If there are characters in your language that are not supported
	         * by Mukta, translate this to 'off'. Do not translate into your own language.
	         */
	        if ( 'off' !== _x( 'on', 'Mukta font: on or off', 'azure-blogger' ) ) {
	            $font_families[] = 'Mukta:400,600,700';
	        }

			/*
	         * Translators: If there are characters in your language that are not supported
	         * by Arvo, translate this to 'off'. Do not translate into your own language.
	         */
	        if ( 'off' !== _x( 'on', 'Arvo font: on or off', 'azure-blogger' ) ) {
	            $font_families[] = 'Arvo:400,600,700';
	        }

	        if( $font_families ) {
	            $query_args = array(
	                'family' => urlencode( implode( '|', $font_families ) ),
	                'subset' => urlencode( 'latin,latin-ext' ),
	            );

	            $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
	        }

	        return $fonts_url;
	    }

	endif;

/*------------------------- Enqueue scripts -----------------------------------*/

	add_action( 'wp_enqueue_scripts', 'azure_blogger_scripts', 99 );

	if ( ! function_exists( 'azure_blogger_scripts' ) ) :

		/**
		 * function to load style and scripts for theme.
		 *
		 */
		function azure_blogger_scripts() {

		    wp_enqueue_style( 'azure-blogger-google-font', azure_blogger_fonts_url(), array(), null );

		    wp_dequeue_style( 'azure-news-style' );

		    wp_dequeue_style( 'azure-news-responsive-style' );

		    wp_enqueue_style( 'azure-blogger-parent-style', get_template_directory_uri() . '/style.css', array(), AZURE_BLOGGER_VERSION );

		    wp_enqueue_style( 'azure-blogger-parent-responsive-style', get_template_directory_uri() . '/assets/css/azure-news-responsive.css', array(), AZURE_BLOGGER_VERSION );

			wp_enqueue_style( 'azure-blogger-responsive-style', get_stylesheet_directory_uri() . '/assets/css/responsive.css', array(), AZURE_BLOGGER_VERSION );

		    wp_enqueue_style( 'azure-blogger-style', get_stylesheet_uri(), array(), AZURE_BLOGGER_VERSION);
		}

	endif;

/*------------------------- Customizer Section --------------------------------*/

	if ( ! function_exists( 'azure_blogger_customize_register' ) ) :

		/**
		 * Managed all the customizer field for theme.
		 */
		function azure_blogger_customize_register( $wp_customize ) {

        global $wp_customize;

        /**
         * Azure Blogger Default Primary Color.
         *
         * @since 1.0.0
         */
        $wp_customize->get_setting( 'azure_news_primary_theme_color' )->default = '#628b74';
		$wp_customize->get_setting( 'azure_news_link_color' )->default = '#628b74';
		$wp_customize->get_setting( 'azure_news_link_hover_color' )->default = '#025e2b';


            /**
             * Color Picker field for Footer Main Area background color
             *
             * Footer Settings > Main Area
             *
             * @since 1.0.0
             */
            $wp_customize->add_setting( 'azure_blogger_footer_main_bg_color',
                array(
                    'default'           => '#caddc1',
                    'sanitize_callback' => 'sanitize_hex_color',
                )
            );
            $wp_customize->add_control( new WP_Customize_Color_Control(
                $wp_customize, 'azure_blogger_footer_main_bg_color',
                    array(
                        'priority'          => 50,
                        'section'           => 'azure_news_section_footer_main',
                        'settings'          => 'azure_blogger_footer_main_bg_color',
                        'label'             => __( 'Background Color', 'azure-blogger' )
                    )
                )
            );

		}

	endif;

	
   add_action( 'customize_register', 'azure_blogger_customize_register', 20 );

/*---------------------- General CSS-------------------------*/

	if ( ! function_exists( 'azure_blogger_general_css' ) ) :

	    /**
	     * function to handle the genral css for all sections.
	     *
	     * @since 1.0.0
	     */
	    function azure_blogger_general_css( $output_css ) {

        $azure_blogger_primary_theme_color 		   = get_theme_mod( 'azure_news_primary_theme_color', '#628b74' );
		$azure_blogger_news_link_color             = get_theme_mod( 'azure_news_link_color', '#628b74' );
		$azure_blogger_news_link_hover_color       = get_theme_mod( 'azure_news_link_hover_color', '#025e2b' );


        //define variable for custom css
        $custom_css = '';

		// Background Color
		$custom_css .= ".azure-news-wave .az-rect,.azure-news-folding-cube .az-cube:before , .azure-news-three-bounce .az-child, .search-icon-close, .navigation .nav-links a, .bttn,button,input[type='button'],input[type='reset'],input[type='submit'],.page-header .page-title::after,.page-header .page-title::before,.navigation .nav-links a.page-numbers:hover,.navigation .nav-links .page-numbers.current,.reply .comment-reply-link,#top-header,.sticky-sidebar-close,.subcribe-ads-button a,#site-navigation #primary-menu > li > a::after,#site-navigation .menu-item-description,.news-ticker-label,.azure-news-banner-wrapper .banner-tabbed-wrapper ul.banner-tabs li.ui-state-active a,.banner-tabbed-wrapper ul.banner-tabs li:hover a,.block-wrapper .block-title:before,.block-wrapper .block-title:after,.widget-title:before,.widget-title:after,.trending-posts .post-thumbnail-wrap .post-count,.azure-news-button.read-more-button a:hover,#azure-news-scrollup,.site-info,.related-post-title::before,.related-post-title::after,.page.type-page .entry-title::before,.page.type-page .entry-title::after,.azure-news-site-layout--boxed,.error-404.not-found .error-button-wrap a,.header-search-wrapper .search-form-wrap .search-submit, .wp-block-search__button,#site-navigation #primary-menu>li>a::after, #site-navigation ul.nav-menu>li>a::after {background-color: ". esc_attr( $azure_blogger_primary_theme_color ) ."}\n";

		 // Color
		 $custom_css .= " #site-navigation ul li a:hover, .posted-on:hover, .azure-news-banner-wrapper .tabbed-content-wrapper a:hover, .entry-cat .cat-links a:hover,.entry-cat a:hover,.byline:hover, .byline a:hover,.posted-on a:hover,.comment-author .fn .url:hover,#cancel-comment-reply-link,.logged-in-as a,.edit-link a,.widget a:hover,.widget a:hover::before,.widget li:hover::before,.entry-title a:hover,.post-title a:hover,.social-icons-wrapper .social-icon i:hover,#site-navigation ul li.current-menu-item > a,#site-navigation ul li.current_page_item > a,#site-navigation ul li.current-menu-ancestor > a,.azure-news-banner-wrapper .tabbed-content-wrapper a:hover,.author-name,.block-posts-wrapper .post-cats-wrap .post-cats-list .post-cat-item a,.trending-posts-wrapper .post-content-wrap .post-cat-item a,.latest-posts-wrapper .post-content-wrap .post-cat-item a,.both-sidebar .azure-news-post-content-wrap .entry-title a:hover,.azure-news-post-content-wrap .entry-meta span a:hover,.azure-news-author-website a,.related-posts-wrapper .post-cats-wrap .post-cat-item a,.azure-news-author-name a,a:hover,a:focus,a:active,.screen-reader-text:hover,.screen-reader-text:active,.screen-reader-text:focus,#cancel-comment-reply-link:before,.azure-news-post-content-wrap .entry-meta span a:hover,.azure-news-post-content-wrap .entry-meta span:hover:before,.header-search-wrapper .search-icon a:hover,.dark-mode .widget a:hover::before,.dark-mode .widget_nav_menu li a:hover,
		 .dark-mode .wp-block-latest-posts li a:hover,
		 .dark-mode .wp-block-archives li a:hover, 
		 .dark-mode .wp-block-categories li a:hover,
		 .dark-mode .wp-block-page-list li a:hover,
		 .dark-mode .wp-block-categories li a:hover{color: ". esc_attr( $azure_blogger_primary_theme_color ) ."}\n";


		// Border Color
		$custom_css .= ".navigation .nav-links a,.bttn,button,input[type='button'],input[type='reset'],input[type='submit'],.navigation .nav-links a.page-numbers:hover,.navigation .nav-links .page-numbers.current,.sticky-sidebar-close,.header-search-wrapper .search-form-wrap .search-submit,.azure-news-banner-wrapper .banner-tabbed-wrapper ul.banner-tabs li.ui-state-active a,.banner-tabbed-wrapper ul.banner-tabs li:hover a,.azure-news-button.read-more-button a:hover{border-color: ". esc_attr( $azure_blogger_primary_theme_color ) ."}\n";

		// Border Left Color
		$custom_css .= "#site-navigation ul.sub-menu,#site-navigation ul.children,#site-navigation ul.sub-menu li,#site-navigation ul.children li{border-left-color: ". esc_attr( $azure_blogger_primary_theme_color ) ."}\n";

		// Border bottom Color
		$custom_css .= ".header-search-wrapper .search-form-wrap::before{border-bottom-color: ". esc_attr( $azure_blogger_primary_theme_color ) ."}\n";


		// Border Top Color
		$custom_css .= ".header-search-wrapper .search-form-wrap,#site-navigation .menu-item-description::after,#site-navigation ul li.current-menu-item > a, #site-navigation ul li.current_page_item > a, #site-navigation ul li.current-menu-ancestor > a{border-top-color: ". esc_attr( $azure_blogger_primary_theme_color ) ."}\n";
	
		// Preloader Color
		$custom_css .= ".azure-news-wave .og-rect,.azure-news-three-bounce .og-child,.azure-news-folding-cube .og-cube:before{background-color: ". esc_attr( $azure_blogger_primary_theme_color ) ."}\n";

		// Responsive color
		$custom_css .= "@media (max-width: 769px) { .azure-news-menu-toogle,
		.subcribe-ads-button a,.sidebar-toggle-search-wrapper .sidebar-menu-toggle {background-color: ". esc_attr( $azure_blogger_primary_theme_color ) ."}}\n";


		 // Link Color
		 $custom_css .= ".page-content a, .entry-content a, .entry-summary a {color: ". esc_attr( $azure_blogger_news_link_color ) ."}\n";

		 // Link Hover Color
		 $custom_css .= ".page-content a:hover, .entry-content a:hover, .entry-summary a:hover, .azure-news-author-website a:hover{color: ". esc_attr( $azure_blogger_news_link_hover_color ) ."}\n";


		$footer_area_bg_color = get_theme_mod( 'azure_blogger_footer_main_bg_color', '#caddc1' );

		// Footer Area Color
		$custom_css .= "#colophon{ background:". esc_attr(  $footer_area_bg_color ) ."}\n";

		if ( ! empty( $custom_css ) ) {
			$output_css .= $custom_css;
		}

		return $output_css;

	    }

	endif;

	add_filter( 'azure_news_head_css', 'azure_blogger_general_css', 999 );
