<?php

define( 'APPOINTABLE_THEME_VERSION', '16.8' );

function appointable_css() {
    $parent_style = 'specia-parent-style';
	wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' );
	wp_enqueue_style( 'appointable-main', get_stylesheet_uri(), array( $parent_style ));
	
	wp_enqueue_style('appointable-default',get_stylesheet_directory_uri() .'/css/colors/default.css');
	wp_dequeue_style('specia-default');
	
	wp_enqueue_style('appointable-media-query',get_stylesheet_directory_uri() .'/css/media-query.css');
	wp_dequeue_style('specia-media-query');
}
add_action( 'wp_enqueue_scripts', 'appointable_css',999);


require_once( get_stylesheet_directory() . '/inc/customize/appointable-header-section.php');
require_once( get_stylesheet_directory() . '/inc/customize/appointable-premium.php');

/**
 * Import Options From Specia Theme
 *
 */
function appointable_parent_theme_options() {
	$specia_mods = get_option( 'theme_mods_specia' );
	if ( ! empty( $specia_mods ) ) {
		foreach ( $specia_mods as $specia_mod_k => $specia_mod_v ) {
			set_theme_mod( $specia_mod_k, $specia_mod_v );
		}
	}
}
add_action( 'after_switch_theme', 'appointable_parent_theme_options' );