# import tkinter library
import tkinter
# import messagebox to display text in dialog box
from tkinter import messagebox  
# importing pandas which will help to perform operations on csv file
import pandas

class Stocks:
    def stockMaxMin(self):
        # reading the csv file with ',' as the delimiter
        stock = pandas.read_csv('Dow Jones Stocks February.csv')
        # dropping the first Date column
        stock = stock.drop(columns=['Date'])
        # creating new pandas dataframe to hold the final values
        ans = pandas.DataFrame(index=['Maximum', 'Minimum'])
        # calculating maximum and minimum values in each column and storing the stock's data in ans dataframe
        for i in range(stock.shape[1]):
            mx = max(stock.iloc[:, i])
            mn = min(stock.iloc[:, i])
            ans.insert(i, stock.columns[i], [mx, mn])
        # creating a dialog box to display the maximum and minimum data of the stocks
        messagebox.showinfo("Stock Details", str(ans))

    def createGUI(self):
        gui = tkinter.Tk()
        tkinter.Button(gui, text="Evaluate maximum and minimum value of stocks", command=self.stockMaxMin).pack()
        gui.mainloop()

obj = Stocks()
obj.createGUI()
