// C program implementing Disjoint Set Data Structure

#include <stdio.h>
#include <stdlib.h>

// Definition of a Node in the Disjoint Set Data Structure
struct Node
{
    struct Node *parent; // pointer to the parent node
    int data;            // data of the node
};

// Definition of the Data Set, which is a collection of disjoint sets
struct data_set
{
    struct Node *head; // pointer to the head of the disjoint set
};

struct data_set *a; // pointer to the data set
int n = 0;          // number of disjoint sets

// Function to get a Node with a given data value from the data set
struct Node *get(int p)
{
    for (int i = 0; i < n; i++)   // iterate through all the disjoint sets
        if (a[i].head->data == p) // if the data of the head of the disjoint set is equal to the given data value
            return a[i].head;     // return the pointer to the head of the disjoint set
    return NULL;                  // if the given data value is not found in any of the disjoint sets, return NULL
}

// Function to create a new disjoint set with a given data value
void makedata_set(int p)
{
    if (get(p) != NULL)
        return; // if the given data value is already present in the data set, return
    struct Node *x;
    x = (struct Node *)malloc(sizeof(struct Node));                       // allocate memory for a new Node
    x->data = p;                                                          // set the data of the new Node
    x->parent = x;                                                        // set the parent of the new Node to itself, since it is the only element in its disjoint set
    a = (struct data_set *)realloc(a, (n + 1) * sizeof(struct data_set)); // increase the size of the data set by 1
    a[n].head = x;                                                        // set the head of the new disjoint set to the new Node
    n++;                                                                  // increase the number of disjoint sets by 1
}

// Function to find the representative element of the disjoint set containing a given element
struct Node *find(int p)
{
    struct Node *x;
    x = get(p); // get the Node with the given data value
    if (x == NULL)
        return NULL;       // if the Node is not found in the data set, return NULL
    while (x->parent != x) // while the parent of the Node is not itself, i.e. the Node is not the representative element of its disjoint set
    {
        x = x->parent; // set the Node to its parent
    }
    return x; // return the representative element of the disjoint set
}

// Function to merge two disjoint sets containing given elements
void union1(int p, int q)
{
    struct Node *x, *y;
    x = find(p); // find the representative element of the disjoint set containing the first element
    y = find(q); // find the representative element of the disjoint set containing the second element
    if (x == y)
        return; // if the two elements are already in the same disjoint set, return
    else
        y->parent = x; // set the parent of the representative element of the second disjoint set to the representative element of the first disjoint set, effectively merging the two disjoint sets
}

// Main function
int main()
{
    while (1)
    {
        char op;
        scanf("%c", &op);
        switch (op)
        {
        case 't':
        {
            int val1, val2;
            scanf("%d", &val1);
            scanf("%d", &val2);
            makedata_set(val1);
            makedata_set(val2);
            union1(val1, val2);
            break;
        }
        case 'T':
        {
            int cnt = 0;
            for (int i = 0; i < n; i++)
                if (a[i].head->parent == a[i].head)
                    cnt++;
            printf("%d\n", cnt);
            break;
        }
        case 'v':
        {
            int val1, val2;
            scanf("%d", &val1);
            scanf("%d", &val2);
            if (val1 > val2)
            {
                printf("-1\n");
                break;
            }
            struct Node *p1 = find(val1);
            struct Node *p2 = find(val2);
            if (p1 == NULL || p2 == NULL || p1 == p2)
                printf("-1\n");
            else
                printf("1\n");
            break;
        }
        case 'd':
        {
            int cnt = 0;
            for (int i = 0; i < n; i++)
            {
                for (int j = 1; j < n; j++)
                {
                    int val1 = a[i].head->data;
                    int val2 = a[j].head->data;
                    if (val1 > val2)
                        continue;
                    struct Node *p1 = find(val1);
                    struct Node *p2 = find(val2);
                    if (p1 != p2)
                        cnt++;
                }
            }
            printf("%d\n", cnt);
            break;
        }
        case 'e':
        {
            exit(0);
        }
        }
    }
}