#include <stdio.h>
#include <stdlib.h>

// First type of node in disjoint set
struct firstNode
{
    struct firstNode *parent1; // Pointer to parent node
    int data1; // Data stored in the node
};

// Second type of node in disjoint set
struct secondNode
{
    struct secondNode *parent2; // Pointer to parent node
    int data2; // Data stored in the node
    int rank; // Rank of the node (used in union operation)
};

// Disjoint set using first type of node
struct disjointSet1
{
    struct firstNode *head1; // Pointer to the head node of the set
};

// Disjoint set using second type of node
struct disjointSet2
{
    struct secondNode *head2; // Pointer to the head node of the set
};

struct disjointSet1 *a, *c; // Pointers to array of disjoint sets using first type of node
struct disjointSet2 *b, *d; // Pointers to array of disjoint sets using second type of node

int n1 = 0, n2 = 0, n3 = 0, n4 = 0; // Count of number of disjoint sets of each type
int c1 = 0, c2 = 0, c3 = 0, c4 = 0; // Count of number of comparisons performed in each find operation

// Function to get the node with data p in disjoint sets using first type of node
struct firstNode *get1(int p)
{
    for (int i = 0; i < n1; i++)
        if (a[i].head1->data1 == p)
            return a[i].head1;
    return NULL;
}

// Function to get the node with data p in disjoint sets using second type of node
struct secondNode *get2(int p)
{
    for (int i = 0; i < n2; i++)
        if (b[i].head2->data2 == p)
            return b[i].head2;
    return NULL;
}

// Function to get the node with data p in disjoint sets using first type of node (used in union operation)
struct firstNode *get3(int p)
{
    for (int i = 0; i < n3; i++)
        if (c[i].head1->data1 == p)
            return c[i].head1;
    return NULL;
}

// Function to get the node with data p in disjoint sets using second type of node (used in union operation)
struct secondNode *get4(int p)
{
    for (int i = 0; i < n4; i++)
        if (d[i].head2->data2 == p)
            return d[i].head2;
    return NULL;
}

// Function to create a new disjoint set using first type of node
void makedisjointSet1(int p)
{
    struct firstNode *x;
    x = (struct firstNode *)malloc(sizeof(struct firstNode)); // Allocate memory for the new node
    x->data1 = p;
    x->parent1 = x; // Initialize the parent pointer to itself
    a = (struct disjointSet1 *)realloc(a, (n1 + 1) * sizeof(struct disjointSet1)); // Resize the array of disjoint sets
    a[n1].head1 = x; // Make the new node the head of a new disjoint set
    n1++; // Increment the count of disjoint sets
}

// Function to create a new disjoint set using second type of node
void makedisjointSet2(int p)
{
    struct secondNode *x;
    x = (struct secondNode *)malloc(sizeof(struct secondNode));
    x->data2 = p;
    x->rank = 0;
    x->parent2 = x;
    b = (struct disjointSet2 *)realloc(b, (n2 + 1) * sizeof(struct disjointSet2));
    b[n2].head2 = x;
    n2++;
}
void makedisjointSet3(int p)
{
    struct firstNode *x;
    x = (struct firstNode *)malloc(sizeof(struct firstNode));
    x->data1 = p;
    x->parent1 = x;
    c = (struct disjointSet1 *)realloc(c, (n3 + 1) * sizeof(struct disjointSet1));
    c[n3].head1 = x;
    n3++;
}

void makedisjointSet4(int p)
{
    struct secondNode *x;
    x = (struct secondNode *)malloc(sizeof(struct secondNode));
    x->data2 = p;
    x->rank = 0;
    x->parent2 = x;
    d = (struct disjointSet2 *)realloc(d, (n4 + 1) * sizeof(struct disjointSet2));
    d[n4].head2 = x;
    n4++;
}
struct firstNode *finddisjointSet1(int p)
{
    c1++;
    struct firstNode *x;
    x = get1(p);
    while (x->parent1 != x)
    {
        x = x->parent1;
        c1++;
    }
    return x;
}
struct secondNode *finddisjointSet2(int p)
{
    c2++;
    struct secondNode *x;
    x = get2(p);
    while (x->parent2 != x)
    {
        x = x->parent2;
        c2++;
    }
    return x;
}
struct firstNode *finddisjointSet3(int p)
{
    c3++;
    struct firstNode *x;
    x = get3(p);
    if (x->parent1 != x)
    {
        x->parent1 = finddisjointSet3(x->parent1->data1);
    }
    return x->parent1;
}
struct secondNode *finddisjointSet4(int p)
{
    c4++;
    struct secondNode *x;
    x = get4(p);
    if (x->parent2 != x)
    {
        x->parent2 = finddisjointSet4(x->parent2->data2);
    }
    return x->parent2;
}
// Function to union two nodes in the first disjoint set using parent pointers
void union1(int p, int q)
{
    struct firstNode *x, *y;
    x = finddisjointSet1(p);  // Find the root node of set containing p
    y = finddisjointSet1(q);  // Find the root node of set containing q
    
    // If both nodes already belong to the same set, print the data of root node
    if (x == y)
        printf("%d ", x->data1);
    else
    {
        // If not, set the parent of the second node to point to the first node
        if (x != y)
            y->parent1 = x;
        
        // Print the data of the root node of the merged set
        printf("%d ", x->data1);
    }
}

// Function to union two nodes in the second disjoint set using rank-based optimizations
void union2(int p, int q)
{
    struct secondNode *x, *y;
    x = finddisjointSet2(p);  // Find the root node of set containing p
    y = finddisjointSet2(q);  // Find the root node of set containing q
    
    // If both nodes already belong to the same set, print the data of root node
    if (x == y)
        printf("%d ", x->data2);
    else
    {
        // If not, merge the smaller set into the larger set and update rank accordingly
        if (x->rank >= y->rank)
        {
            y->parent2 = x;
            printf("%d ", x->data2);
        }
        else
        {
            x->parent2 = y;
            printf("%d ", y->data2);
        }

        if (x->rank == y->rank)
            x->rank = x->rank + 1;
    }
}

// Function to union two nodes in the third disjoint set using parent pointers (same as union1)
void union3(int p, int q)
{
    struct firstNode *x, *y;
    x = finddisjointSet3(p);
    y = finddisjointSet3(q);
    if (x == y)
        printf("%d ", x->data1);
    else
    {
        if (x != y)
            y->parent1 = x;
        printf("%d ", x->data1);
    }
}

// Function to union two nodes in the fourth disjoint set using rank-based optimizations (same as union2)
void union4(int p, int q)
{
    struct secondNode *x, *y;
    x = finddisjointSet4(p);
    y = finddisjointSet4(q);
    if (x == y)
        printf("%d\n", x->data2);
    else
    {
        if (x->rank >= y->rank)
        {
            y->parent2 = x;
            printf("%d\n", x->data2);
        }
        else
        {
            x->parent2 = y;
            printf("%d\n", y->data2);
        }

        if (x->rank == y->rank)
            x->rank = x->rank + 1;
    }
}


int main()
{
    struct firstNode *g1, *g3;
    struct secondNode *g2, *g4;

    a = (struct disjointSet1 *)malloc(sizeof(struct disjointSet1));
    b = (struct disjointSet2 *)malloc(sizeof(struct disjointSet2));
    c = (struct disjointSet1 *)malloc(sizeof(struct disjointSet1));
    d = (struct disjointSet2 *)malloc(sizeof(struct disjointSet2));

    int key, key1, key2;
    char ch;
    int i;
    while (1)
    {
        scanf("%c", &ch);
        if (ch == 'm')
        {
            scanf("%d", &key);
            for (i = 0; i < n1; i++)
                if (a[i].head1->data1 == key)
                    break;

            if (i != n1)
                printf("PRESENT\n");

            else
            {
                makedisjointSet1(key);
                makedisjointSet2(key);
                makedisjointSet3(key);
                makedisjointSet4(key);
                printf("%d\n", key);
            }
        }
        else if (ch == 'f')
        {
            scanf("%d", &key);
            for (i = 0; i < n1; i++)
                if (a[i].head1->data1 == key)
                    break;

            if (i != n1)
            {
                g1 = finddisjointSet1(key);
                printf("%d ", g1->data1);
                g2 = finddisjointSet2(key);
                printf("%d ", g2->data2);
                g3 = finddisjointSet3(key);
                printf("%d ", g3->data1);
                g4 = finddisjointSet4(key);
                printf("%d\n", g4->data2);
            }
            else
                printf("NOT FOUND\n");
        }
        else if (ch == 'u')
        {
            scanf("%d %d", &key1, &key2);
            for (i = 0; i < n1; i++)
                if (a[i].head1->data1 == key1)
                    break;
            if (i == n1)
            {
                printf("Error\n");
                continue;
            }
            for (i = 0; i < n1; i++)
                if (a[i].head1->data1 == key2)
                    break;
            if (i == n1)
            {
                printf("Error\n");
                continue;
            }

            union1(key1, key2);
            union2(key1, key2);
            union3(key1, key2);
            union4(key1, key2);
        }
        else if (ch == 's')
        {
            printf("%d ", c1);
            printf("%d ", c2);
            printf("%d ", c3);
            printf("%d\n", c4);
            break;
        }
    }
    return 0;
}