#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include<string.h>

// Define the node structure for the Binomial Heap
struct Node
{
    int key;                // value of the node
    int degree;             // degree of the node
    struct Node *parent;    // parent of the node
    struct Node *child;     // child of the node
    struct Node *sibling;   // sibling of the node
};

// Function prototypes
struct Node *find(struct Node *h, int val);
struct Node *createNode(int val);
struct Node *merge(struct Node *h1, struct Node *h2);
struct Node *link(struct Node *x, struct Node *y);
struct Node *Union(struct Node *h1, struct Node *h2);
void display(struct Node *h);
struct Node* delete(struct Node *h, int val);
int decreaseKey(struct Node *h1, int val, int new_value);
struct Node *extractminimum(struct Node *h);
struct Node *revertList(struct Node *h1);
struct Node *minimum(struct Node *h);
struct Node *insert(struct Node *h, int val);

// Initialize the Binomial Heap
struct Node *h1 = NULL;
struct Node *h2 = NULL;


// Initialize an array to store the roots of trees in the heap
struct Node *disp[10001] = {NULL};

// Function to create a new node and initialize its fields
struct Node *createNode(int val)
{
    struct Node *temp = (struct Node *)malloc(sizeof(struct Node));
    temp->key = val;
    temp->parent = temp->child = temp->sibling = NULL;
    temp->degree = 0;
    return temp;
}

// Function to merge two heaps
struct Node *merge(struct Node *h1, struct Node *h2)
{
    if (h1 == NULL)
    {
        return h2;
    }
    if (h2 == NULL)
    {
        return h1;
    }

    // Initialize pointers to keep track of the trees in the heaps
    struct Node *S = NULL;
    if (h1->degree <= h2->degree)
    {
        S = h1;
        h1 = S->sibling;
    }
    else
    {
        S = h2;
        h2 = S->sibling;
    }

    // Initialize a pointer to the new heap
    struct Node *H_new = S;

    // Traverse both heaps and merge them
    while (h1 != NULL && h2 != NULL)
    {
        if (h1->degree <= h2->degree)
        {
            S->sibling = h1;
            S = h1;
            h1 = S->sibling;
        }
        else
        {
            S->sibling = h2;
            S = h2;
            h2 = S->sibling;
        }
    }

    // Add any remaining nodes to the new heap
    if (h1 == NULL)
    {
        S->sibling = h2;
    }
    if (h2 == NULL)
    {
        S->sibling = h1;
    }

    // Return the new heap
    return H_new;
}

// Function to link two nodes in a Binomial Heap
struct Node *link(struct Node *x, struct Node *y)
{
    if (x->key > y->key)
    {
        x->sibling = y->child;
        y->child = x;
        x->parent = y;
        y->degree++;
        return y;
    }
    else
    {
        y->sibling = x->child;
        x->child = y;
        y->parent = x;
        x->degree++;
        return x;
    }
}
// Function to union two Binomial Heaps
struct Node *Union(struct Node *h1, struct Node *h2)
{
    struct Node *prev, *cur, *next;
    struct Node *H_new = merge(h1, h2);
    if (H_new == NULL)
    {
        return H_new;
    }
    prev = NULL;
    cur = H_new;
    next = cur->sibling;
    while (next != NULL)
    {
        if ((cur->degree < next->degree) || ((cur->degree == next->degree) && (next->sibling != NULL) && (next->degree == next->sibling->degree)))
        {
            prev = cur;
            cur = next;
            next = next->sibling;
        }
        else
        {
            struct Node *t, *b;
            t = next->sibling;
            b = link(cur, next);
            if (prev == NULL)
            {
                H_new = b;
            }
            else
            {
                prev->sibling = b;
            }
            b->sibling = t;
            cur = b;
            next = t;
        }
    }
    return H_new;
}

// Function to insert a node in a Binomial Heap
struct Node *insert(struct Node *h, int val)
{
    struct Node *new_Node = createNode(val);
    return Union(h, new_Node);
}

// Function to get the minumum node in a Binomial Heap
struct Node *minimum(struct Node *h)
{
    struct Node *min = h, *cur = h;
    while (cur != NULL)
    {
        if (cur->key < min->key)
        {
            min = cur;
        }
        cur = cur->sibling;
    }
    return min;
}

// Function to revert the linked list
struct Node *revertList(struct Node *h1)
{
    struct Node *prev = NULL, *cur = h1, *next = h1->sibling;
    while (cur != NULL)
    {
        cur->parent = NULL;
        cur->sibling = prev;
        prev = cur;
        cur = next;
        if (cur != NULL)
        {
            next = cur->sibling;
        }
    }
    return prev;
}

// Function to get the minumum in a Binomial Heap and delete it
struct Node* extractminimum(struct Node *h)
{
    // find minimum
    struct Node *min = minimum(h);
    if (min == NULL)
    {
        return min;
    }
    if (min == h)
    {
        h = h->sibling;
    }
    else
    {
        struct Node *cur = h;
        while (cur->sibling != min)
        {
            cur = cur->sibling;
        }
        cur->sibling = min->sibling;
    }
    min->sibling = NULL;
    struct Node *q = min->child;
    if (q != NULL)
    {
        q = revertList(q);
        h = Union(h, q);
        min->child = NULL;
    }
    if(min == NULL) printf("-1");
    else printf("%d\n", min -> key);
    return h;
}

// Function to find node in a Binomial Heap
struct Node *find(struct Node *h, int val)
{
    struct Node *x = h, *p = NULL;
    if (x->key == val)
    {
        p = x;
        return p;
    }
    if (x->child != NULL && p == NULL)
    {
        p = find(x->child, val);
    }
    if (x->sibling != NULL && p == NULL)
    {
        p = find(x->sibling, val);
    }
    return p;
}

// Function to decrease key of a node in a Binomial Heap
int decreaseKey(struct Node *h, int val, int new_value)
{
    struct Node *x = find(h, val);
    if(x == NULL) return -1;
    if (val > new_value)
    {
        x->key = new_value;
        struct Node *y = x;
        struct Node *z = x->parent;
        while ((z != NULL) && (y->key < z->key))
        {
            int temp = y->key;
            y->key = z->key;
            z->key = temp;
            y = z;
            z = z->parent;
        }
    }
    return 1;
}

// Function to delete a node by value in a Binomial Heap
struct Node* delete(struct Node *h, int val)
{
    int status = decreaseKey(h, val, INT_MIN);
    return extractminimum(h);
}

void display(struct Node *h)
{
    int c1 = 0;
    struct Node *cur = h;
    while (cur != NULL)
    {
        disp[c1++] = cur;
        cur = cur->sibling;
    }
    int i = 0;
    while (i < c1)
    {
        printf("%d ", disp[i]->key);
        cur = disp[i]->child;
        while (cur != NULL)
        {
            disp[c1++] = cur;
            cur = cur->sibling;
        }
        i++;
    }
    printf("\n");
}

int main()
{
    char input[10];
    char *token;
    char operation;
    int value, amount;
    char choice;
    while (1)
    {
        gets(input);
        if(strcmp(input, "p1") == 0) {
            display(h1);
            continue;
        }
        else if(strcmp(input, "p2") == 0) {
            display(h2);
            continue;
        }
        if (input[0] == '\0')
            break;
        token = strtok(input, " ");
        operation = token[0];

        switch (operation)
        {
        case 'i':
        {
            token = strtok(NULL, " ");
            value = atoi(token);
            h1 = insert(h1, value);
            break;
        }
        case 'j':
        {
            token = strtok(NULL, " ");
            value = atoi(token);
            h2 = insert(h2, value);
            break;
        }

        case 'd':
        {
            token = strtok(NULL, " ");
            value = atoi(token);
            h1 = delete(h1, value);
            break;
        }
        case 'm':
        {
            struct Node *min = minimum(h1);
            if (min != NULL)
            {
                printf("%d\n", min->key);
            }
            else
            {
                printf("EMPTY\n");
            }
            break;
        }
        case 'x':
        {
            h1 = extractminimum(h1);
            break;
        }
        case 'r':
        {
            token = strtok(NULL, " ");
            value = atoi(token);

            token = strtok(NULL, " ");
            amount = atoi(token);

            if (amount >= value)
            {
                printf("%d\n", -1);
                break;
            }

            int status = decreaseKey(h1, value, value - amount);
            if(status == -1) printf("-1\n");
            else printf("%d\n", value - amount);
                
            break;
        }
        case 'u':
        {
            struct Node *h = Union(h1, h2);
            display(h);
            break;
        }
        case 'e':
            exit(0);
        }
    }
}