window.onload = () => {
  // (A) FILE PICKER
  let picker = document.getElementById("demoB");

  // (B) READ CSV FILE
  picker.onchange = () => {
    // (B1) GET SELECTED CSV FILE
    let selected = picker.files[0];

    // (B2) READ CSV INTO ARRAY
    let reader = new FileReader();
    reader.addEventListener("loadend", () => {
      // (B2-1) PARSE INTO ARRAY
      let csv = CSV.parse(reader.result);

      // (B2-2) REARRANGE KEYS & VALUES
      let data = {};
      for (let [col,key] of Object.entries(csv[0])) {
        data[key] = [];
        for (let row=1; row<csv.length; row++) {
          data[key].push(csv[row][col]);
        }
      }
      console.log(data);

      // (B2-3) DONE!
      // data = JSON.stringify(data);
      // picker.value = "";
    });
    reader.readAsText(selected);
  };
};